/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.session.IdentifierMarshallerProvider;

public class SessionKeyMarshaller<K extends Key<String>>
implements ProtoStreamMarshaller<K> {
    private static final int IDENTIFIER_INDEX = 1;
    private static final Marshaller<String, ByteBuffer> IDENTIFIER_MARSHALLER = AccessController.doPrivileged(new PrivilegedAction<Optional<Marshaller<String, ByteBuffer>>>(){

        @Override
        public Optional<Marshaller<String, ByteBuffer>> run() {
            return ServiceLoader.load(IdentifierMarshallerProvider.class, IdentifierMarshallerProvider.class.getClassLoader()).findFirst().map(IdentifierMarshallerProvider::getMarshaller);
        }
    }).orElseThrow(IllegalStateException::new);
    private final Function<String, K> factory;

    public SessionKeyMarshaller(Function<String, K> factory) {
        this.factory = factory;
    }

    public K readFrom(ProtoStreamReader reader) throws IOException {
        ByteBuffer buffer = null;
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    buffer = reader.readByteBuffer();
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (K)((Key)this.factory.apply((String)IDENTIFIER_MARSHALLER.read(buffer)));
    }

    public void writeTo(ProtoStreamWriter writer, K key) throws IOException {
        String id = (String)key.getId();
        if (id != null) {
            writer.writeBytes(1, (ByteBuffer)IDENTIFIER_MARSHALLER.write((Object)id));
        }
    }

    public Class<? extends K> getJavaClass() {
        return ((Key)this.factory.apply("")).getClass();
    }
}

