/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.CompositeImmutableSessionFactory;
import org.wildfly.clustering.session.cache.CompositeSession;
import org.wildfly.clustering.session.cache.Contextual;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.SessionFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;

public class CompositeSessionFactory<DC, MV extends Contextual<SC>, AV, SC>
extends CompositeImmutableSessionFactory<MV, AV>
implements SessionFactory<DC, MV, AV, SC> {
    private final SessionMetaDataFactory<MV> metaDataFactory;
    private final SessionAttributesFactory<DC, AV> attributesFactory;
    private final Supplier<SC> contextFactory;

    public CompositeSessionFactory(SessionFactoryConfiguration<DC, MV, AV, SC> configuration) {
        super(configuration);
        this.metaDataFactory = configuration.getSessionMetaDataFactory();
        this.attributesFactory = configuration.getSessionAttributesFactory();
        this.contextFactory = configuration.getSessionContextFactory();
    }

    @Override
    public SessionMetaDataFactory<MV> getSessionMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<DC, AV> getSessionAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Supplier<SC> getSessionContextFactory() {
        return this.contextFactory;
    }

    @Override
    public Session<SC> createSession(String id, Map.Entry<MV, AV> entry, DC context) {
        Contextual metaDataValue = (Contextual)entry.getKey();
        AV attributesValue = entry.getValue();
        if (metaDataValue == null || attributesValue == null) {
            return null;
        }
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, metaDataValue);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(id, attributesValue, (ImmutableSessionMetaData)metaData, context);
        return new CompositeSession(id, metaData, attributes, metaDataValue.getContext(), this.contextFactory, this);
    }
}

