/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpMessage;
import io.vertx.amqp.AmqpMessageBuilder;
import io.vertx.amqp.impl.AmqpMessageImpl;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.sql.Date;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpMessageBuilderImpl
implements AmqpMessageBuilder {
    private Message message;

    public AmqpMessageBuilderImpl() {
        this.message = Message.Factory.create();
    }

    public AmqpMessageBuilderImpl(AmqpMessage existing) {
        this.message = existing.unwrap();
    }

    public AmqpMessageBuilderImpl(Message existing) {
        this.message = existing;
    }

    @Override
    public AmqpMessage build() {
        return new AmqpMessageImpl(this.message);
    }

    @Override
    public AmqpMessageBuilderImpl priority(short priority) {
        this.message.setPriority(priority);
        return this;
    }

    @Override
    public AmqpMessageBuilder durable(boolean durable) {
        this.message.setDurable(durable);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl id(String id) {
        this.message.setMessageId((Object)id);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl address(String address) {
        this.message.setAddress(address);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl replyTo(String replyTo) {
        this.message.setReplyTo(replyTo);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl correlationId(String correlationId) {
        this.message.setCorrelationId((Object)correlationId);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withBody(String value) {
        this.message.setBody((Section)new AmqpValue((Object)value));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withSymbolAsBody(String value) {
        this.message.setBody((Section)new AmqpValue((Object)Symbol.valueOf((String)value)));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl subject(String subject) {
        this.message.setSubject(subject);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl contentType(String ct) {
        this.message.setContentType(ct);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl contentEncoding(String ct) {
        this.message.setContentEncoding(ct);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl expiryTime(long expiry) {
        this.message.setExpiryTime(expiry);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl creationTime(long ct) {
        this.message.setCreationTime(ct);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl ttl(long ttl) {
        this.message.setTtl(ttl);
        return this;
    }

    @Override
    public AmqpMessageBuilder firstAcquirer(boolean first) {
        this.message.setFirstAcquirer(first);
        return this;
    }

    @Override
    public AmqpMessageBuilder deliveryCount(int count) {
        this.message.setDeliveryCount((long)count);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl groupId(String gi) {
        this.message.setGroupId(gi);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl replyToGroupId(String rt) {
        this.message.setReplyToGroupId(rt);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl applicationProperties(JsonObject props) {
        ApplicationProperties properties = new ApplicationProperties(props.getMap());
        this.message.setApplicationProperties(properties);
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withBooleanAsBody(boolean v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withByteAsBody(byte v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withShortAsBody(short v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withIntegerAsBody(int v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withLongAsBody(long v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withFloatAsBody(float v) {
        this.message.setBody((Section)new AmqpValue((Object)Float.valueOf(v)));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withDoubleAsBody(double v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withCharAsBody(char c) {
        this.message.setBody((Section)new AmqpValue((Object)Character.valueOf(c)));
        return this;
    }

    @Override
    @GenIgnore(value={"permitted-type"})
    public AmqpMessageBuilderImpl withInstantAsBody(Instant v) {
        this.message.setBody((Section)new AmqpValue((Object)Date.from(v)));
        return this;
    }

    @Override
    @GenIgnore(value={"permitted-type"})
    public AmqpMessageBuilderImpl withUuidAsBody(UUID v) {
        this.message.setBody((Section)new AmqpValue((Object)v));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withListAsBody(List list) {
        this.message.setBody((Section)new AmqpValue((Object)list));
        return this;
    }

    @Override
    @GenIgnore(value={"permitted-type"})
    public AmqpMessageBuilderImpl withMapAsBody(Map map) {
        this.message.setBody((Section)new AmqpValue((Object)map));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withBufferAsBody(Buffer buffer) {
        this.message.setBody((Section)new Data(new Binary(buffer.getBytes())));
        return this;
    }

    @Override
    public AmqpMessageBuilderImpl withJsonObjectAsBody(JsonObject json) {
        return this.contentType("application/json").withBufferAsBody(json.toBuffer());
    }

    @Override
    public AmqpMessageBuilderImpl withJsonArrayAsBody(JsonArray json) {
        return this.contentType("application/json").withBufferAsBody(json.toBuffer());
    }
}

