/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.ExtendedThreadMBean;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.ThreadResourceDefinition;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ThreadMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final ThreadMXBeanAttributeHandler INSTANCE = new ThreadMXBeanAttributeHandler();
    private final ParametersValidator enabledValidator = new ParametersValidator();

    private ThreadMXBeanAttributeHandler() {
        this.enabledValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block4: {
            String name = operation.require("name").asString();
            try {
                if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || ThreadResourceDefinition.THREADING_READ_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_METRICS.contains(name)) {
                    ThreadMXBeanAttributeHandler.storeResult(name, context.getResult());
                    break block4;
                }
                if (ThreadResourceDefinition.THREADING_EXTENDED_READ_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_EXTENDED_READ_WRITE_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_EXTENDED_METRICS.contains(name)) {
                    ThreadMXBeanAttributeHandler.storeExtendedResult(name, context.getResult());
                    break block4;
                }
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException | UnsupportedOperationException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }

    static void storeExtendedResult(String name, ModelNode store) {
        ExtendedThreadMBean mbean = new ExtendedThreadMBean();
        if ("current-thread-allocated-bytes".equals(name)) {
            if (mbean.isAttributeDefined("CurrentThreadAllocatedBytes")) {
                store.set(mbean.getCurrentThreadAllocatedBytes());
            }
        } else if ("thread-allocated-memory-enabled".equals(name)) {
            if (mbean.isAttributeDefined("ThreadAllocatedMemoryEnabled")) {
                store.set(mbean.isThreadAllocatedMemoryEnabled());
            }
        } else if ("thread-allocated-memory-supported".equals(name) && mbean.isAttributeDefined("ThreadAllocatedMemorySupported")) {
            store.set(mbean.isThreadAllocatedMemorySupported());
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block7: {
            String name = operation.require("name").asString();
            try {
                if (ThreadResourceDefinition.THREADING_EXTENDED_READ_WRITE_ATTRIBUTES.contains(name)) {
                    this.executeExtendedWriteAttribute(context, operation, name);
                    break block7;
                }
                if ("thread-contention-monitoring-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    context.getServiceRegistry(true);
                    ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(operation.require("value").asBoolean());
                    break block7;
                }
                if ("thread-cpu-time-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    context.getServiceRegistry(true);
                    ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(operation.require("value").asBoolean());
                    break block7;
                }
                if (ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                    throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
                }
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(e.toString());
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.lang:type=Threading");
        } else if ("thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getThreadCount());
        } else if ("peak-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getPeakThreadCount());
        } else if ("total-started-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
        } else if ("daemon-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getDaemonThreadCount());
        } else if ("all-thread-ids".equals(name)) {
            store.setEmptyList();
            long[] lArray = ManagementFactory.getThreadMXBean().getAllThreadIds();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long id = lArray[i];
                store.add(id.longValue());
            }
        } else if ("thread-contention-monitoring-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringSupported());
        } else if ("thread-contention-monitoring-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringEnabled());
        } else if ("current-thread-cpu-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
        } else if ("current-thread-user-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadUserTime());
        } else if ("thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported());
        } else if ("current-thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported());
        } else if ("thread-cpu-time-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled());
        } else if ("object-monitor-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isObjectMonitorUsageSupported());
        } else if ("synchronizer-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isSynchronizerUsageSupported());
        } else if (ThreadResourceDefinition.THREADING_READ_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeExtendedWriteAttribute(OperationContext context, ModelNode operation, String name) throws OperationFailedException {
        ExtendedThreadMBean mbean = new ExtendedThreadMBean();
        if ("thread-allocated-memory-enabled".equals(name)) {
            if (!mbean.isAttributeDefined("ThreadAllocatedMemoryEnabled")) throw PlatformMBeanLogger.ROOT_LOGGER.unsupportedWritableAttribute("thread-allocated-memory-enabled");
            this.enabledValidator.validate(operation);
            context.getServiceRegistry(true);
            mbean.setThreadAllocatedMemoryEnabled(operation.require("value").asBoolean());
            return;
        } else {
            if (!ThreadResourceDefinition.THREADING_EXTENDED_READ_WRITE_ATTRIBUTES.contains(name)) return;
            throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
        }
    }
}

