/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.TransactionInfo;
import org.wildfly.transaction.client.SimpleXid;

final class Serializer {
    private Serializer() {
    }

    static void serializeObject(ObjectOutput output, Object object) throws IOException {
        output.writeObject(object);
    }

    static Object deserializeObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return input.readObject();
    }

    static void serializeObjectArray(ObjectOutput output, Object[] objects) throws IOException {
        if (objects == null) {
            return;
        }
        for (Object object : objects) {
            output.writeObject(object);
        }
    }

    static void deserializeObjectArray(ObjectInput input, Object[] objects) throws IOException, ClassNotFoundException {
        if (objects == null) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = Serializer.deserializeObject(input);
        }
    }

    static void serializePackedInteger(ObjectOutput output, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        if (value > 127) {
            output.writeByte(value & 0x7F | 0x80);
            Serializer.serializePackedInteger(output, value >> 7);
        } else {
            output.writeByte(value & 0xFF);
        }
    }

    static int deserializePackedInteger(ObjectInput input) throws IOException {
        byte ret = input.readByte();
        if ((ret & 0x80) == 128) {
            return Serializer.deserializePackedInteger(input) << 7 | ret & 0x7F;
        }
        return ret;
    }

    static void serializeMap(ObjectOutput output, Map<String, Object> map) throws IOException {
        int size = map != null ? map.size() : 0;
        Serializer.serializePackedInteger(output, size);
        if (size > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                output.writeObject(entry.getKey());
                output.writeObject(entry.getValue());
            }
        }
    }

    static Map<String, Object> deserializeMap(ObjectInput input) throws IOException, ClassNotFoundException {
        int contextDataSize = Serializer.deserializePackedInteger(input);
        if (contextDataSize == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(contextDataSize);
        for (int i = 0; i < contextDataSize; ++i) {
            String key = (String)input.readObject();
            Object value = input.readObject();
            ret.put(key, value);
        }
        return ret;
    }

    static void serializeSet(ObjectOutput output, Set<EJBModuleIdentifier> set) throws IOException {
        output.writeInt(set.size());
        for (EJBModuleIdentifier moduleId : set) {
            output.writeObject(moduleId);
        }
    }

    static Set<EJBModuleIdentifier> deserializeSet(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        HashSet<EJBModuleIdentifier> ret = new HashSet<EJBModuleIdentifier>(size);
        for (int i = 0; i < size; ++i) {
            ret.add((EJBModuleIdentifier)input.readObject());
        }
        return ret;
    }

    static void serializeTransaction(ObjectOutput output, TransactionInfo txnInfo) throws IOException {
        byte transactionType = txnInfo.getType();
        output.writeByte(transactionType);
        if (transactionType == TransactionInfo.NULL_TRANSACTION) {
            return;
        }
        Serializer.serializeXid(output, txnInfo.getXid());
        if (transactionType == TransactionInfo.REMOTE_TRANSACTION) {
            return;
        }
        if (transactionType == TransactionInfo.LOCAL_TRANSACTION) {
            output.writeInt(txnInfo.getRemainingTime());
        }
    }

    static TransactionInfo deserializeTransaction(ObjectInput input) throws IOException {
        byte txnType = input.readByte();
        if (txnType == TransactionInfo.NULL_TRANSACTION) {
            return TransactionInfo.nullTransaction();
        }
        if (txnType == TransactionInfo.REMOTE_TRANSACTION || txnType == TransactionInfo.LOCAL_TRANSACTION) {
            Xid xid = Serializer.deserializeXid(input);
            return txnType == TransactionInfo.REMOTE_TRANSACTION ? TransactionInfo.remoteTransaction(xid) : TransactionInfo.localTransaction(xid, input.readInt());
        }
        throw EjbHttpClientMessages.MESSAGES.invalidTransactionType(txnType);
    }

    static void serializeXid(ObjectOutput output, Xid xid) throws IOException {
        output.writeInt(xid.getFormatId());
        output.writeInt(xid.getGlobalTransactionId().length);
        output.write(xid.getGlobalTransactionId());
        output.writeInt(xid.getBranchQualifier().length);
        output.write(xid.getBranchQualifier());
    }

    static Xid deserializeXid(ObjectInput input) throws IOException {
        int formatId = input.readInt();
        int length = input.readInt();
        byte[] globalId = new byte[length];
        input.readFully(globalId);
        length = input.readInt();
        byte[] branchId = new byte[length];
        input.readFully(branchId);
        return new SimpleXid(formatId, globalId, branchId);
    }
}

