/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jboss.ejb.client.EJBLocator;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.Protocol;
import org.wildfly.httpclient.ejb.Constants;
import org.wildfly.httpclient.ejb.RequestType;

final class RequestBuilder {
    private EJBLocator<?> locator;
    private String beanId;
    private String view;
    private Method method;
    private RequestType requestType;
    private String invocationId;
    private int version = Protocol.LATEST;
    private boolean cancelIfRunning;
    private boolean compressRequest;
    private boolean compressResponse;

    RequestBuilder() {
    }

    RequestBuilder setCompressRequest(boolean compressRequest) {
        this.compressRequest = compressRequest;
        return this;
    }

    RequestBuilder setCompressResponse(boolean compressResponse) {
        this.compressResponse = compressResponse;
        return this;
    }

    RequestBuilder setLocator(EJBLocator<?> locator) {
        this.locator = locator;
        return this;
    }

    RequestBuilder setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    RequestBuilder setMethod(Method method) {
        this.method = method;
        return this;
    }

    RequestBuilder setView(String view) {
        this.view = view;
        return this;
    }

    RequestBuilder setRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    RequestBuilder setInvocationId(String invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    RequestBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    RequestBuilder setCancelIfRunning(boolean cancelIfRunning) {
        this.cancelIfRunning = cancelIfRunning;
        return this;
    }

    ClientRequest createRequest(String prefix) {
        ClientRequest request = new ClientRequest();
        this.setRequestMethod(request);
        this.setRequestPath(request, prefix);
        this.setRequestHeaders(request);
        return request;
    }

    private void setRequestMethod(ClientRequest request) {
        request.setMethod(this.requestType.getMethod());
    }

    private void setRequestPath(ClientRequest request, String prefix) {
        switch (this.requestType) {
            case INVOKE: {
                request.setPath(this.getStartEjbInvocationRequestPath(prefix));
                break;
            }
            case CREATE_SESSION: {
                request.setPath(this.getCreateSessionEjbRequestPath(prefix));
                break;
            }
            case DISCOVER: {
                request.setPath(this.getDiscoverEjbRequestPath(prefix));
                break;
            }
            case CANCEL: {
                request.setPath(this.getCancelEjbInvocationRequestPath(prefix));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setRequestHeaders(ClientRequest request) {
        switch (this.requestType) {
            case INVOKE: {
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (String)(String.valueOf(Constants.INVOCATION_ACCEPT) + "," + String.valueOf(Constants.EJB_EXCEPTION)));
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.CONTENT_TYPE, (ContentType)Constants.INVOCATION);
                if (this.invocationId != null) {
                    HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Constants.INVOCATION_ID, (String)this.invocationId);
                }
                if (this.compressRequest) {
                    HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.CONTENT_ENCODING, (HttpString)Headers.GZIP);
                }
                if (this.compressResponse) {
                    HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT_ENCODING, (HttpString)Headers.GZIP);
                }
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.TRANSFER_ENCODING, (HttpString)Headers.CHUNKED);
                break;
            }
            case CREATE_SESSION: {
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (ContentType)Constants.EJB_EXCEPTION);
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.CONTENT_TYPE, (ContentType)Constants.SESSION_OPEN);
                break;
            }
            case DISCOVER: {
                HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (String)(String.valueOf(Constants.EJB_DISCOVERY_RESPONSE) + "," + String.valueOf(Constants.EJB_EXCEPTION)));
                break;
            }
            case CANCEL: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private String getCreateSessionEjbRequestPath(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.appendOperationPath(sb, prefix);
        this.appendBeanPath(sb);
        return sb.toString();
    }

    private String getDiscoverEjbRequestPath(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.appendOperationPath(sb, prefix);
        return sb.toString();
    }

    private String getCancelEjbInvocationRequestPath(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.appendOperationPath(sb, prefix);
        this.appendBeanPath(sb);
        RequestBuilder.appendPath(sb, this.invocationId, false);
        RequestBuilder.appendPath(sb, "" + this.cancelIfRunning, false);
        return sb.toString();
    }

    private String getStartEjbInvocationRequestPath(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.appendOperationPath(sb, prefix);
        this.appendBeanPath(sb);
        RequestBuilder.appendPath(sb, this.beanId, false);
        RequestBuilder.appendPath(sb, this.view, false);
        RequestBuilder.appendPath(sb, this.method.getName(), false);
        for (Class<?> param : this.method.getParameterTypes()) {
            RequestBuilder.appendPath(sb, param.getName(), true);
        }
        return sb.toString();
    }

    private void appendBeanPath(StringBuilder sb) {
        RequestBuilder.appendPath(sb, this.locator.getAppName(), true);
        RequestBuilder.appendPath(sb, this.locator.getModuleName(), true);
        RequestBuilder.appendPath(sb, this.locator.getDistinctName(), true);
        RequestBuilder.appendPath(sb, this.locator.getBeanName(), true);
    }

    private void appendOperationPath(StringBuilder sb, String prefix) {
        if (prefix != null) {
            sb.append(prefix);
        }
        RequestBuilder.appendPath(sb, "/ejb", false);
        RequestBuilder.appendPath(sb, "/v" + this.version, false);
        RequestBuilder.appendPath(sb, this.requestType.getPath(), false);
    }

    private static void appendPath(StringBuilder sb, String path, boolean encode) {
        if (path == null || !path.startsWith("/") || encode) {
            sb.append("/");
        }
        sb.append(path == null || path.isEmpty() ? "-" : (encode ? URLEncoder.encode(path, StandardCharsets.UTF_8) : path));
    }
}

