/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerFactory;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagementConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagementProvider;
import org.wildfly.clustering.ejb.timer.TimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.ejb.timer.TimerServiceConfiguration;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.infinispan.service.CacheConfigurationServiceInstaller;
import org.wildfly.clustering.infinispan.service.CacheServiceInstaller;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanTimerManagementProvider
implements TimerManagementProvider,
UnaryOperator<ConfigurationBuilder> {
    private final TimerManagementConfiguration configuration;
    private final BinaryServiceConfiguration cacheConfiguration;

    public InfinispanTimerManagementProvider(TimerManagementConfiguration configuration, BinaryServiceConfiguration cacheConfiguration) {
        this.configuration = configuration;
        this.cacheConfiguration = cacheConfiguration;
    }

    public <I> Iterable<ServiceInstaller> getTimerManagerFactoryServiceInstallers(ServiceName name, final TimerManagerFactoryConfiguration<I> configuration) {
        BinaryServiceConfiguration timerManagerCacheConfiguration = this.cacheConfiguration.withChildName(configuration.getTimerServiceConfiguration().getName());
        CacheConfigurationServiceInstaller cacheConfigurationInstaller = new CacheConfigurationServiceInstaller(timerManagerCacheConfiguration, CacheConfigurationServiceInstaller.fromTemplate((BinaryServiceConfiguration)this.cacheConfiguration).map((Function)this));
        CacheServiceInstaller cacheInstaller = new CacheServiceInstaller(timerManagerCacheConfiguration);
        final ServiceDependency commandDispatcherFactory = timerManagerCacheConfiguration.getServiceDependency(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).map(CacheContainerCommandDispatcherFactory.class::cast);
        final ServiceDependency cache = timerManagerCacheConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        InfinispanTimerManagerFactoryConfiguration factoryConfiguration = new InfinispanTimerManagerFactoryConfiguration<I>(){

            public TimerServiceConfiguration getTimerServiceConfiguration() {
                return configuration.getTimerServiceConfiguration();
            }

            public TimerRegistry<I> getRegistry() {
                return configuration.getRegistry();
            }

            public boolean isPersistent() {
                return configuration.isPersistent();
            }

            public Supplier<I> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }

            @Override
            public ByteBufferMarshaller getMarshaller() {
                return (ByteBufferMarshaller)InfinispanTimerManagementProvider.this.configuration.getMarshallerFactory().apply(configuration.getTimerServiceConfiguration().getModule());
            }

            @Override
            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return (CacheContainerCommandDispatcherFactory)commandDispatcherFactory.get();
            }
        };
        ServiceInstaller factoryInstaller = (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(new InfinispanTimerManagerFactory(factoryConfiguration)).provides(name)).startWhen(Installer.StartWhen.REQUIRED)).requires(List.of(commandDispatcherFactory, cache))).build();
        return List.of(cacheConfigurationInstaller, cacheInstaller, factoryInstaller);
    }

    @Override
    public ConfigurationBuilder apply(ConfigurationBuilder builder) {
        OptionalInt size;
        ExpirationConfiguration expiration = builder.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder.expiration().lifespan(-1L).maxIdle(-1L);
        }
        EvictionStrategy strategy = (size = this.configuration.getMaxActiveTimers()).isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
        builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount((long)size.orElse(0));
        if (strategy.isEnabled()) {
            ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(TimerMetaDataKey.class::isInstance);
        }
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(EmbeddedTransactionManager::getInstance).lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return builder;
    }
}

