/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataKey;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.cache.bean.OnCloseBean;
import org.wildfly.clustering.ejb.infinispan.bean.BeanExpirationTask;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataFilter;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleExpirationCommand;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactoryService;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntriesTask;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntrySchedulerService;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerService;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerService;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.server.scheduler.SchedulerService;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InfinispanBeanManager<K, V extends BeanInstance<K>, M>
implements BeanManager<K, V> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(BeanExpirationTask.class, WildFlySecurityManager.getClassLoaderPrivileged(BeanExpirationTask.class));
    private final Cache<BeanMetaDataKey<K>, M> cache;
    private final Predicate<Map.Entry<? super BeanMetaDataKey<K>, ? super M>> filter;
    private final BeanFactory<K, V, M> beanFactory;
    private final IdentifierFactoryService<K> identifierFactory;
    private final CacheContainerCommandDispatcherFactory dispatcherFactory;
    private final BeanExpirationConfiguration<K, V> expiration;
    private final org.wildfly.clustering.function.Supplier<Batch> batchFactory;
    private final Function<K, CacheContainerGroupMember> primaryOwnerLocator;
    private final Affinity strongAffinity;
    private final SchedulerService<K, ExpirationMetaData> scheduler;
    private volatile UnaryOperator<Bean<K, V>> transformer;

    public InfinispanBeanManager(final InfinispanBeanManagerConfiguration<K, V, M> configuration) {
        final Cache cache = configuration.getCache();
        this.beanFactory = configuration.getBeanFactory();
        this.cache = cache;
        this.batchFactory = configuration.getBatchFactory();
        this.identifierFactory = new AffinityIdentifierFactoryService((Supplier)configuration.getIdentifierFactory(), this.cache);
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpiration();
        CacheContainerGroup group = this.dispatcherFactory.getGroup();
        this.primaryOwnerLocator = new UnaryGroupMemberAffinity(configuration.getCache(), group);
        this.strongAffinity = this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(group.getName()) : new NodeAffinity(((CacheContainerGroupMember)group.getLocalMember()).getName());
        InfinispanBeanMetaDataFilter filter = new InfinispanBeanMetaDataFilter(configuration.getBeanName());
        this.filter = filter;
        final ScheduledEntries entries = group.isSingleton() ? ScheduledEntries.queued() : ScheduledEntries.sorted();
        final BeanExpirationTask<K, V, M> removeTask = this.expiration != null && !this.expiration.getTimeout().isZero() ? new BeanExpirationTask<K, V, M>(this.beanFactory, (Supplier<Batch>)this.batchFactory, this.expiration.getExpirationListener()) : null;
        final String schedulerName = String.join((CharSequence)"/", configuration.getName(), configuration.getBeanName());
        LocalSchedulerService localScheduler = removeTask != null ? new LocalSchedulerService(new LocalSchedulerService.Configuration<K>(){

            public String getName() {
                return schedulerName;
            }

            public ScheduledEntries<K, Instant> getScheduledEntries() {
                return entries;
            }

            public Predicate<K> getTask() {
                return removeTask;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }

            public Duration getCloseTimeout() {
                return configuration.getStopTimeout();
            }
        }) : null;
        BeanMetaDataFactory metaDataFactory = this.beanFactory.getMetaDataFactory();
        final CacheEntrySchedulerService cacheEntryScheduler = localScheduler != null ? new CacheEntrySchedulerService<K, BeanMetaDataKey<K>, M, ExpirationMetaData>(localScheduler.compose(Function.identity(), ExpirationMetaData::getExpirationTime), (arg_0, arg_1) -> ((ImmutableBeanMetaDataFactory)metaDataFactory).createImmutableBeanMetaData(arg_0, arg_1)){

            public void start() {
                super.start();
                CacheEntriesTask.schedule(InfinispanBeanManager.this.cache, InfinispanBeanManager.this.filter, (CacheEntryScheduler)this).accept((Object)CacheStreamFilter.local(InfinispanBeanManager.this.cache));
            }
        } : null;
        this.scheduler = cacheEntryScheduler != null && !group.isSingleton() ? new PrimaryOwnerSchedulerService(new PrimaryOwnerSchedulerService.Configuration<K, ExpirationMetaData, Map.Entry<BeanMetaDataKey<K>, M>, Map.Entry<BeanMetaDataKey<K>, M>>(){
            final /* synthetic */ Predicate val$filter;
            {
                this.val$filter = predicate;
            }

            public String getName() {
                return schedulerName;
            }

            public SchedulerService<K, ExpirationMetaData> getScheduler() {
                return cacheEntryScheduler;
            }

            public EmbeddedCacheConfiguration getCacheConfiguration() {
                return configuration;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return configuration.getCommandDispatcherFactory();
            }

            public java.util.function.Consumer<CacheStreamFilter<Map.Entry<BeanMetaDataKey<K>, M>>> getCancelTask() {
                return CacheEntriesTask.cancel((Cache)cache, (Predicate)this.val$filter, (CacheEntryScheduler)cacheEntryScheduler);
            }

            public java.util.function.Consumer<CacheStreamFilter<Map.Entry<BeanMetaDataKey<K>, M>>> getScheduleTask() {
                return CacheEntriesTask.schedule((Cache)cache, (Predicate)this.val$filter, (CacheEntryScheduler)cacheEntryScheduler);
            }

            public Function<Map.Entry<K, ExpirationMetaData>, PrimaryOwnerCommand<K, ExpirationMetaData, Void>> getScheduleCommandFactory() {
                return ScheduleExpirationCommand::new;
            }
        }) : cacheEntryScheduler;
        Consumer closeTask = this.expiration != null ? bean -> {
            if (bean.isValid()) {
                if (this.scheduler != null) {
                    this.scheduler.schedule(bean.getId(), (Object)bean.getMetaData());
                } else {
                    bean.remove(this.expiration.getExpirationListener());
                }
            }
        } : null;
        this.transformer = closeTask != null ? bean -> new OnCloseBean(bean, (java.util.function.Consumer)closeTask) : UnaryOperator.identity();
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        this.identifierFactory.start();
        if (this.scheduler != null) {
            this.scheduler.start();
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.identifierFactory.stop();
    }

    public void close() {
        Consumer.close().accept(this.scheduler);
    }

    public boolean isRemotable(Throwable throwable) {
        for (Throwable subject = throwable; subject != null; subject = subject.getCause()) {
            if (!(subject instanceof CacheException)) continue;
            return false;
        }
        return true;
    }

    public Affinity getStrongAffinity() {
        return this.strongAffinity;
    }

    public Affinity getWeakAffinity(K id) {
        Configuration config = this.cache.getCacheConfiguration();
        CacheMode mode = config.clustering().cacheMode();
        if (mode.isClustered()) {
            CacheContainerGroupMember member = this.primaryOwnerLocator.apply(id);
            return new NodeAffinity(member.getName());
        }
        return Affinity.NONE;
    }

    public Bean<K, V> createBean(V instance, K groupId) {
        Object id = instance.getId();
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        MutableBean bean = this.beanFactory.createBean(id, this.beanFactory.createValue(instance, groupId));
        bean.setInstance(instance);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean<K, V> findBean(K id) throws java.util.concurrent.TimeoutException {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        Object value = this.beanFactory.findValue(id);
        if (value == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel(id);
        }
        try {
            MutableBean bean = this.beanFactory.createBean(id, value);
            if (bean.getInstance() == null) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Bean %s metadata was found, but bean instance was not, most likely due to passivation failure.", id);
                try {
                    this.beanFactory.purge(id);
                }
                finally {
                    bean.close();
                }
                return null;
            }
            if (bean.getMetaData().isExpired()) {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Bean %s found, but was expired", id);
                try {
                    bean.remove(this.expiration.getExpirationListener());
                }
                finally {
                    bean.close();
                }
                return null;
            }
            return (Bean)this.transformer.apply((Bean<K, V>)bean);
        }
        catch (TimeoutException e) {
            throw new java.util.concurrent.TimeoutException(e.getLocalizedMessage());
        }
    }

    public org.wildfly.clustering.function.Supplier<K> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public org.wildfly.clustering.function.Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public int getActiveCount() {
        return this.count(EnumSet.of(Flag.SKIP_CACHE_LOAD));
    }

    public int getPassiveCount() {
        return this.count(Set.of()) - this.getActiveCount();
    }

    private int count(Set<Flag> flags) {
        CacheStreamFilter filter = CacheStreamFilter.local(this.cache);
        try (Stream entries = (Stream)filter.apply((Object)this.cache.getAdvancedCache().withFlags(flags).entrySet().stream());){
            int n = (int)entries.filter(this.filter).count();
            return n;
        }
    }
}

