/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class BeanExpirationTask<K, V extends BeanInstance<K>, M>
implements Predicate<K> {
    private final BeanFactory<K, V, M> beanFactory;
    private final Supplier<Batch> batchFactory;
    private final Consumer<V> expirationListener;

    BeanExpirationTask(BeanFactory<K, V, M> beanFactory, Supplier<Batch> batchFactory, Consumer<V> expirationListener) {
        this.beanFactory = beanFactory;
        this.batchFactory = batchFactory;
        this.expirationListener = expirationListener;
    }

    @Override
    public boolean test(K id) {
        boolean bl;
        block19: {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", id);
            Batch batch = this.batchFactory.get();
            try {
                Object value = this.beanFactory.tryValue(id);
                if (value != null) {
                    try (MutableBean bean = this.beanFactory.createBean(id, value);){
                        if (bean.getMetaData().isExpired()) {
                            bean.remove(this.expirationListener);
                        }
                    }
                }
                bl = true;
                if (batch == null) break block19;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        batch.discard();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (batch != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (RuntimeException e2) {
                    InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e2, id);
                    return false;
                }
            }
            batch.close();
        }
        return bl;
    }
}

