/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.CacheConfigurationAttributeGroup;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.DistributableWebSubsystemResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.NoAffinityResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.SessionGranularity;
import org.wildfly.extension.clustering.web.SessionMarshallerFactory;
import org.wildfly.extension.clustering.web.session.DistributableSessionManagementProviderFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class SessionManagementResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
UnaryOperator<ResourceDescriptor.Builder> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)DistributableSessionManagementProvider.SERVICE_DESCRIPTOR).addRequirements(new String[]{RoutingProvider.SERVICE_DESCRIPTOR.getName()}).setAllowMultipleRegistrations(true).build();
    static final EnumAttributeDefinition<SessionGranularity> GRANULARITY = new EnumAttributeDefinition.Builder("granularity", SessionGranularity.class).build();
    static final EnumAttributeDefinition<SessionMarshallerFactory> MARSHALLER = new EnumAttributeDefinition.Builder("marshaller", (Enum)SessionMarshallerFactory.JBOSS).build();
    private final ResourceRegistration registration;
    private final CacheConfigurationAttributeGroup cacheAttributeGroup;
    private final DistributableSessionManagementProviderFactory providerFactory;

    SessionManagementResourceDefinitionRegistrar(ResourceRegistration registration, CacheConfigurationAttributeGroup cacheAttributeGroup, DistributableSessionManagementProviderFactory providerFactory) {
        this.registration = registration;
        this.cacheAttributeGroup = cacheAttributeGroup;
        this.providerFactory = providerFactory;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addCapability(CAPABILITY)).addAttributes(this.cacheAttributeGroup.getAttributes())).addAttributes(List.of(GRANULARITY, MARSHALLER))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = DistributableWebSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.registration.getPathElement(), PathElement.pathElement((String)"session-management"));
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new NoAffinityResourceDefinitionRegistrar().register(registration, context);
        new LocalAffinityResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final SessionGranularity granularity = (SessionGranularity)GRANULARITY.resolve(context, model);
        final SessionMarshallerFactory marshallerFactory = (SessionMarshallerFactory)MARSHALLER.resolve(context, model);
        DistributableSessionManagementConfiguration<DeploymentUnit> configuration = new DistributableSessionManagementConfiguration<DeploymentUnit>(){

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return granularity.getAttributePersistenceStrategy();
            }

            public Function<DeploymentUnit, ByteBufferMarshaller> getMarshallerFactory() {
                return marshallerFactory;
            }
        };
        BinaryServiceConfiguration cacheConfiguration = this.cacheAttributeGroup.resolve(context, model);
        final DistributableSessionManagementProviderFactory providerFactory = this.providerFactory;
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)RouteLocatorProvider.SERVICE_DESCRIPTOR, (String)context.getCurrentAddressValue()).map((Function)new Function<RouteLocatorProvider, Object>((DistributableSessionManagementConfiguration)configuration, cacheConfiguration){
            final /* synthetic */ DistributableSessionManagementConfiguration val$configuration;
            final /* synthetic */ BinaryServiceConfiguration val$cacheConfiguration;
            {
                this.val$configuration = distributableSessionManagementConfiguration;
                this.val$cacheConfiguration = binaryServiceConfiguration;
            }

            @Override
            public DistributableSessionManagementProvider apply(RouteLocatorProvider locatorProvider) {
                return providerFactory.createSessionManagementProvider((DistributableSessionManagementConfiguration<DeploymentUnit>)this.val$configuration, this.val$cacheConfiguration, locatorProvider);
            }
        })).build();
    }
}

