/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts;

import com.arjuna.mwlabs.wsas.activity.ActivityReaper;
import com.arjuna.services.framework.task.TaskManager;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jbossts.XTSServiceMBean;
import org.jboss.jbossts.xts.environment.XTSEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.jboss.jbossts.xts.initialisation.XTSInitialisation;
import org.jboss.jbossts.xts.logging.XTSLogger;
import org.jboss.jbossts.xts.recovery.coordinator.CoordinatorRecoveryInitialisation;

public class XTSService
implements XTSServiceMBean {
    private int taskManagerMinWorkerCount = 0;
    private int taskManagerMaxWorkerCount = 10;
    private List<XTSInitialisation> xtsInitialisations = new ArrayList<XTSInitialisation>();

    public void start() throws Exception {
        XTSLogger.logger.info((Object)"JBossTS XTS Transaction Service - starting");
        XTSEnvironmentBean xtsEnvironmentBean = XTSPropertyManager.getXTSEnvironmentBean();
        for (String className : xtsEnvironmentBean.getXtsInitialisations()) {
            Class<?> clazz = null;
            try {
                clazz = CoordinatorRecoveryInitialisation.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                XTSLogger.i18NLogger.error_XTSService_1(className, cnfe);
                continue;
            }
            if (!XTSInitialisation.class.isAssignableFrom(clazz)) {
                XTSLogger.i18NLogger.error_XTSService_2(className);
                continue;
            }
            try {
                XTSInitialisation initialisation = (XTSInitialisation)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                initialisation.startup();
                this.xtsInitialisations.add(initialisation);
            }
            catch (InstantiationException ie) {
                XTSLogger.i18NLogger.error_XTSService_3(className, ie);
            }
            catch (IllegalAccessException iae) {
                XTSLogger.i18NLogger.error_XTSService_4(className, iae);
            }
        }
        this.TaskManagerInitialisation();
    }

    public void stop() throws Exception {
        XTSLogger.logger.info((Object)"JBossTS XTS Transaction Service - stopping");
        TaskManager.getManager().shutdown();
        ActivityReaper.shutdown();
        for (XTSInitialisation xtsInitialisation : this.xtsInitialisations) {
            xtsInitialisation.shutdown();
        }
        this.xtsInitialisations.clear();
    }

    private void TaskManagerInitialisation() {
        TaskManager taskManager = TaskManager.getManager();
        taskManager.setMinimumWorkerCount(this.taskManagerMinWorkerCount);
        taskManager.setMaximumWorkerCount(this.taskManagerMaxWorkerCount);
    }
}

