/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorRPCProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.CompletionCoordinatorParticipant;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.soap.SOAPFaultException;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionCoordinatorRPCProcessorImpl
extends CompletionCoordinatorRPCProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(CompletionCoordinatorParticipant participant, String identifier) {
        this.activatedObjectProcessor.activateObject(participant, identifier);
    }

    @Override
    public void deactivateParticipant(CompletionCoordinatorParticipant participant) {
        this.activatedObjectProcessor.deactivateObject(participant);
    }

    private CompletionCoordinatorParticipant getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (CompletionCoordinatorParticipant)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public boolean commit(Notification commit, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
        try {
            if (participant != null) {
                try {
                    participant.commit();
                }
                catch (TransactionRolledBackException trbe) {
                    return false;
                }
                catch (UnknownTransactionException ute) {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_1());
                    throw new SOAPFaultException(soapFault);
                }
                catch (SystemException se) {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_2());
                    throw new SOAPFaultException(soapFault);
                }
                catch (Throwable th) {
                    if (WSTLogger.logger.isTraceEnabled()) {
                        WSTLogger.logger.tracev("Unexpected exception thrown from commit:", (Object)th);
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_2());
                    throw new SOAPFaultException(soapFault);
                }
                return true;
            }
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Commit called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
            soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_5());
            throw new SOAPFaultException(soapFault);
        }
        catch (SOAPException se) {
            WSTLogger.logger.warn((Object)se.getMessage(), (Throwable)se);
            throw new ProtocolException((Throwable)se);
        }
    }

    @Override
    public boolean rollback(Notification rollback, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
        try {
            if (participant != null) {
                String messageId = MessageId.getMessageId();
                try {
                    participant.rollback();
                    return true;
                }
                catch (UnknownTransactionException ute) {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_6());
                    throw new SOAPFaultException(soapFault);
                }
                catch (SystemException se) {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_7());
                    throw new SOAPFaultException(soapFault);
                }
                catch (Throwable th) {
                    if (WSTLogger.logger.isTraceEnabled()) {
                        WSTLogger.logger.tracev("Unexpected exception thrown from commit:", (Object)th);
                    }
                    SOAPFactory factory = SOAPFactory.newInstance();
                    SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME);
                    soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_7());
                    throw new SOAPFaultException(soapFault);
                }
            }
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Rollback called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPFault soapFault = factory.createFault(SoapFaultType.FAULT_SENDER.getValue(), ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME);
            soapFault.addDetail().addDetailEntry(ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME).addTextNode(WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_10());
            throw new SOAPFaultException(soapFault);
        }
        catch (SOAPException se) {
            WSTLogger.logger.warn((Object)se.getMessage(), (Throwable)se);
            throw new ProtocolException((Throwable)se);
        }
    }
}

