/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarj;

import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.w3c.dom.Element;

public class InstanceIdentifier {
    private String instanceIdentifier;
    private static SOAPFactory factory = InstanceIdentifier.createSoapFactory();
    private static Name WSARJ_ELEMENT_INSTANCE_NAME;

    public InstanceIdentifier() {
    }

    public InstanceIdentifier(String instanceIdentifier) {
        this.instanceIdentifier = instanceIdentifier;
    }

    public void setInstanceIdentifier(String instanceIdentifier) {
        this.instanceIdentifier = instanceIdentifier;
    }

    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public boolean isValid() {
        return this.instanceIdentifier != null && this.instanceIdentifier.trim().length() > 0;
    }

    public String toString() {
        return this.instanceIdentifier != null ? this.instanceIdentifier : "";
    }

    public static void setEndpointInstanceIdentifier(W3CEndpointReferenceBuilder builder, String identifier) {
        builder.referenceParameter(InstanceIdentifier.createInstanceIdentifierElement(identifier));
    }

    public static void setEndpointInstanceIdentifier(W3CEndpointReferenceBuilder builder, InstanceIdentifier instanceIdentifier) {
        builder.referenceParameter(InstanceIdentifier.createInstanceIdentifierElement(instanceIdentifier.getInstanceIdentifier()));
    }

    public static void setEndpointInstanceIdentifier(MAPEndpoint epReference, InstanceIdentifier instanceIdentifier) {
        InstanceIdentifier.setEndpointInstanceIdentifier(epReference, instanceIdentifier.getInstanceIdentifier());
    }

    public static void setEndpointInstanceIdentifier(MAPEndpoint epReference, String instanceIdentifier) {
        epReference.addReferenceParameter(InstanceIdentifier.createInstanceIdentifierElement(instanceIdentifier));
    }

    public static Element createInstanceIdentifierElement(String instanceIdentifier) {
        try {
            SOAPElement element = factory.createElement(WSARJ_ELEMENT_INSTANCE_NAME);
            element.addNamespaceDeclaration("wsarj", "http://schemas.arjuna.com/ws/2005/10/wsarj");
            element.addTextNode(instanceIdentifier);
            return element;
        }
        catch (SOAPException se) {
            return null;
        }
    }

    private static SOAPFactory createSoapFactory() {
        try {
            Name name;
            SOAPFactory factory = SOAPFactory.newInstance();
            WSARJ_ELEMENT_INSTANCE_NAME = name = factory.createName("InstanceIdentifier", "wsarj", "http://schemas.arjuna.com/ws/2005/10/wsarj");
            return factory;
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }
}

