/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.at;

import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wscf.model.twophase.api.CoordinatorManager;
import com.arjuna.mw.wscf11.model.twophase.CoordinatorManagerFactory;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wscf.coordinator.LocalFactory;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.ATCoordinator;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.CoordinatorControl;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.CoordinatorServiceImple;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import com.arjuna.mwlabs.wscf.utils.ContextProvider;
import com.arjuna.mwlabs.wst11.at.RegistrarImple;
import com.arjuna.mwlabs.wst11.at.context.ArjunaContextImple;
import com.arjuna.mwlabs.wst11.at.participants.CleanupSynchronization;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.processors.ParticipantProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc.InvalidCreateParametersException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc11.ContextFactory;
import com.arjuna.wsc11.ContextFactoryMapper;
import com.arjuna.wsc11.RegistrationCoordinator;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst11.messaging.engines.ParticipantEngine;
import com.arjuna.wst11.stub.SubordinateDurable2PCStub;
import com.arjuna.wst11.stub.SubordinateVolatile2PCStub;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContext;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.Expires;

@ContextProvider(coordinationType="http://docs.oasis-open.org/ws-tx/wsat/2006/06", serviceType="TwoPhase11HLS", contextImplementation=ArjunaContextImple.class)
public class ContextFactoryImple
implements ContextFactory,
LocalFactory {
    private CoordinatorManager _coordManager;
    private RegistrarImple _theRegistrar;

    public ContextFactoryImple() {
        try {
            this._coordManager = CoordinatorManagerFactory.coordinatorManager();
            this._theRegistrar = new RegistrarImple();
            ContextFactoryMapper.getMapper().addContextFactory("http://docs.oasis-open.org/ws-tx/wsat/2006/06", this);
        }
        catch (Exception ex) {
            wstxLogger.i18NLogger.warn_unexpectedExcpetion(ex);
        }
    }

    @Override
    public void install(String coordinationTypeURI) {
    }

    @Override
    public CoordinationContext create(String coordinationTypeURI, Long expires, CoordinationContextType currentContext, boolean isSecure) throws InvalidCreateParametersException {
        if (coordinationTypeURI.equals("http://docs.oasis-open.org/ws-tx/wsat/2006/06")) {
            try {
                long transactionExpires;
                if (currentContext == null) {
                    long timeoutVal;
                    this._coordManager.suspend();
                    int timeout = expires == null ? 0 : ((timeoutVal = expires.longValue()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeoutVal);
                    this._coordManager.begin("TwoPhase11HLS", timeout);
                    ArjunaContextImple arjunaContext = ArjunaContextImple.getContext();
                    ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
                    String registrationCoordinatorURI = serviceRegistry.getServiceURI("RegistrationService", isSecure);
                    CoordinationContext coordinationContext = new CoordinationContext();
                    coordinationContext.setCoordinationType(coordinationTypeURI);
                    CoordinationContextType.Identifier identifier = new CoordinationContextType.Identifier();
                    identifier.setValue("urn:" + arjunaContext.getTransactionIdentifier());
                    coordinationContext.setIdentifier(identifier);
                    int transactionExpires2 = arjunaContext.getTransactionExpires();
                    if (transactionExpires2 > 0) {
                        Expires expiresInstance = new Expires();
                        expiresInstance.setValue(transactionExpires2);
                        coordinationContext.setExpires(expiresInstance);
                    }
                    W3CEndpointReference registrationCoordinator = ContextFactoryImple.getRegistrationCoordinator(registrationCoordinatorURI, arjunaContext);
                    coordinationContext.setRegistrationService(registrationCoordinator);
                    this._coordManager.enlistSynchronization(new CleanupSynchronization(this._coordManager.identifier().toString(), this._theRegistrar));
                    this._theRegistrar.associate();
                    return coordinationContext;
                }
                SubordinateATCoordinator subTx = (SubordinateATCoordinator)((Object)this.createSubordinate());
                String vtppid = subTx.getVolatile2PhaseId();
                String dtppid = subTx.getDurable2PhaseId();
                SubordinateVolatile2PCStub vtpp = new SubordinateVolatile2PCStub(subTx);
                SubordinateDurable2PCStub dtpp = new SubordinateDurable2PCStub(subTx);
                String messageId = MessageId.getMessageId();
                W3CEndpointReference participant = this.getParticipant(vtppid, isSecure);
                W3CEndpointReference coordinator = RegistrationCoordinator.register(currentContext, messageId, participant, "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Volatile2PC");
                ParticipantProcessor.getProcessor().activateParticipant(new ParticipantEngine(vtpp, vtppid, coordinator), vtppid);
                participant = this.getParticipant(dtppid, isSecure);
                coordinator = RegistrationCoordinator.register(currentContext, messageId, participant, "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC");
                ParticipantProcessor.getProcessor().activateParticipant(new ParticipantEngine(dtpp, dtppid, coordinator), dtppid);
                ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
                String registrationCoordinatorURI = serviceRegistry.getServiceURI("RegistrationService", isSecure);
                CoordinationContext coordinationContext = new CoordinationContext();
                coordinationContext.setCoordinationType(coordinationTypeURI);
                CoordinationContextType.Identifier identifier = new CoordinationContextType.Identifier();
                String txId = subTx.get_uid().stringForm();
                identifier.setValue("urn:" + txId);
                coordinationContext.setIdentifier(identifier);
                Expires expiresInstance = currentContext.getExpires();
                long l = transactionExpires = expiresInstance != null ? expiresInstance.getValue() : 0L;
                if (transactionExpires > 0L) {
                    expiresInstance = new Expires();
                    expiresInstance.setValue(transactionExpires);
                    coordinationContext.setExpires(expiresInstance);
                }
                W3CEndpointReference registrationCoordinator = ContextFactoryImple.getRegistrationCoordinator(registrationCoordinatorURI, txId);
                coordinationContext.setRegistrationService(registrationCoordinator);
                this._theRegistrar.associate(subTx);
                return coordinationContext;
            }
            catch (NoActivityException | WrongStateException ex) {
                wstxLogger.i18NLogger.warn_unexpectedExcpetion(ex);
                throw new InvalidCreateParametersException();
            }
            catch (Exception ex) {
                wstxLogger.i18NLogger.warn_unexpectedExcpetion(ex);
            }
        } else {
            wstxLogger.i18NLogger.warn_mwlabs_wst_at_Context11FactoryImple_1("http://docs.oasis-open.org/ws-tx/wsat/2006/06", coordinationTypeURI);
            throw new InvalidCreateParametersException(wstxLogger.i18NLogger.get_mwlabs_wst_at_Context11FactoryImple_3() + " < http://docs.oasis-open.org/ws-tx/wsat/2006/06, " + coordinationTypeURI + " >");
        }
        return null;
    }

    public BridgeTxData createBridgedTransaction(String subordinateType, Long expires, boolean isSecure) {
        if (subordinateType == null || "org.jboss.jbossts.xts.at.at.subordinate".equals(subordinateType)) {
            return null;
        }
        SubordinateATCoordinator subTx = null;
        try {
            subTx = (SubordinateATCoordinator)((Object)this.createSubordinate(subordinateType));
        }
        catch (NoActivityException e) {
            return null;
        }
        catch (InvalidProtocolException e) {
            return null;
        }
        catch (SystemException e) {
            return null;
        }
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String registrationCoordinatorURI = serviceRegistry.getServiceURI("RegistrationService", isSecure);
        CoordinationContext coordinationContext = new CoordinationContext();
        coordinationContext.setCoordinationType("http://docs.oasis-open.org/ws-tx/wsat/2006/06");
        CoordinationContextType.Identifier identifier = new CoordinationContextType.Identifier();
        String txId = subTx.get_uid().stringForm();
        identifier.setValue("urn:" + txId);
        coordinationContext.setIdentifier(identifier);
        if (expires != null && expires > 0L) {
            Expires expiresInstance = new Expires();
            expiresInstance.setValue(expires);
            coordinationContext.setExpires(expiresInstance);
        }
        W3CEndpointReference registrationCoordinator = ContextFactoryImple.getRegistrationCoordinator(registrationCoordinatorURI, txId);
        coordinationContext.setRegistrationService(registrationCoordinator);
        try {
            this._theRegistrar.associate(subTx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BridgeTxData bridgeTxData = new BridgeTxData();
        bridgeTxData.context = coordinationContext;
        bridgeTxData.coordinator = subTx;
        bridgeTxData.identifier = txId;
        return bridgeTxData;
    }

    private W3CEndpointReference getParticipant(String id, boolean isSecure) {
        QName serviceName = AtomicTransactionConstants.PARTICIPANT_SERVICE_QNAME;
        QName endpointName = AtomicTransactionConstants.PARTICIPANT_PORT_QNAME;
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String address = serviceRegistry.getServiceURI("ParticipantService", isSecure);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.serviceName(serviceName);
        builder.endpointName(endpointName);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier(builder, id);
        return builder.build();
    }

    private static W3CEndpointReference getRegistrationCoordinator(String registrationCoordinatorURI, ArjunaContextImple arjunaContext) {
        String identifier = arjunaContext.getTransactionIdentifier();
        return ContextFactoryImple.getRegistrationCoordinator(registrationCoordinatorURI, identifier);
    }

    private static W3CEndpointReference getRegistrationCoordinator(String registrationCoordinatorURI, String identifier) {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.serviceName(CoordinationConstants.REGISTRATION_SERVICE_QNAME);
        builder.endpointName(CoordinationConstants.REGISTRATION_ENDPOINT_QNAME);
        builder.address(registrationCoordinatorURI);
        InstanceIdentifier.setEndpointInstanceIdentifier(builder, identifier);
        W3CEndpointReference registrationCoordinator = builder.build();
        return registrationCoordinator;
    }

    @Override
    public void uninstall(String coordinationTypeURI) {
    }

    @Override
    public final Object createSubordinate() throws NoActivityException, InvalidProtocolException, SystemException {
        return this.createSubordinate("org.jboss.jbossts.xts.at.at.subordinate");
    }

    @Override
    public final Object createSubordinate(String subordinateType) throws NoActivityException, InvalidProtocolException, SystemException {
        try {
            CoordinatorServiceImple coordManager = (CoordinatorServiceImple)this._coordManager;
            CoordinatorControl theControl = coordManager.coordinatorControl();
            ATCoordinator subordinateTransaction = theControl.createSubordinate(subordinateType);
            subordinateTransaction.enlistSynchronization(new CleanupSynchronization(subordinateTransaction.get_uid().stringForm(), this._theRegistrar));
            this._theRegistrar.associate(subordinateTransaction);
            return subordinateTransaction;
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public final RegistrarImple registrar() {
        return this._theRegistrar;
    }

    public class BridgeTxData {
        public CoordinationContext context;
        public SubordinateATCoordinator coordinator;
        public String identifier;
    }
}

