/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

@FunctionalInterface
public interface AttributeTransformationRequirementChecker {
    public static final AttributeTransformationRequirementChecker SIMPLE_EXPRESSIONS = new AttributeTransformationRequirementChecker(){
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

        @Override
        public boolean isAttributeTransformationRequired(String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.checkForExpression(attributeValue);
        }

        private boolean checkForExpression(ModelNode node) {
            if (!node.isDefined()) {
                return false;
            }
            ModelNode resolved = node.clone();
            if (node.getType() == ModelType.EXPRESSION || node.getType() == ModelType.STRING) {
                return this.checkForExpression(resolved.asString());
            }
            if (node.getType() == ModelType.OBJECT) {
                for (Property prop : resolved.asPropertyList()) {
                    if (!this.checkForExpression(prop.getValue())) continue;
                    return true;
                }
            } else if (node.getType() == ModelType.LIST) {
                for (ModelNode current : resolved.asList()) {
                    if (!this.checkForExpression(current)) continue;
                    return true;
                }
            } else if (node.getType() == ModelType.PROPERTY) {
                return this.checkForExpression(resolved.asProperty().getValue());
            }
            return false;
        }

        private boolean checkForExpression(String value) {
            return this.EXPRESSION_PATTERN.matcher(value).matches();
        }
    };
    public static final AttributeTransformationRequirementChecker SIMPLE_LIST_EXPRESSIONS = new ListAttributeTransformationRequirementChecker(SIMPLE_EXPRESSIONS);

    public boolean isAttributeTransformationRequired(String var1, ModelNode var2, TransformationContext var3);

    public static class ListAttributeTransformationRequirementChecker
    implements AttributeTransformationRequirementChecker {
        private final AttributeTransformationRequirementChecker elementChecker;

        public ListAttributeTransformationRequirementChecker(AttributeTransformationRequirementChecker elementChecker) {
            this.elementChecker = elementChecker;
        }

        @Override
        public boolean isAttributeTransformationRequired(String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode element : attributeValue.asList()) {
                    if (!this.elementChecker.isAttributeTransformationRequired(attributeName, element, context)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class ObjectFieldsAttributeTransformationRequirementChecker
    implements AttributeTransformationRequirementChecker {
        private final Map<String, AttributeTransformationRequirementChecker> fields = new HashMap<String, AttributeTransformationRequirementChecker>();

        public ObjectFieldsAttributeTransformationRequirementChecker(Map<String, AttributeTransformationRequirementChecker> fields) {
            this.fields.putAll(fields);
        }

        @Override
        public boolean isAttributeTransformationRequired(String attributeName, ModelNode attributeValue, TransformationContext context) {
            for (Map.Entry<String, AttributeTransformationRequirementChecker> entry : this.fields.entrySet()) {
                ModelNode fieldValue;
                ModelNode modelNode = fieldValue = attributeValue.hasDefined(entry.getKey()) ? attributeValue.get(entry.getKey()) : new ModelNode();
                if (!entry.getValue().isAttributeTransformationRequired(attributeName, fieldValue, context)) continue;
                return true;
            }
            return false;
        }
    }
}

