/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.GlobalTransformerRegistry;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformerEntry;
import org.jboss.dmr.ModelNode;

public class OperationTransformerRegistry {
    private final PathAddressTransformer pathAddressTransformer;
    private final ResourceTransformerEntry resourceTransformer;
    private final OperationTransformerEntry defaultTransformer;
    private final boolean placeholder;
    private volatile Map<String, SubRegistry> subRegistries;
    private volatile Map<String, OperationTransformerEntry> transformerEntries;
    private static final AtomicMapFieldUpdater<OperationTransformerRegistry, String, SubRegistry> subRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(OperationTransformerRegistry.class, Map.class, "subRegistries"));
    private static final AtomicMapFieldUpdater<OperationTransformerRegistry, String, OperationTransformerEntry> entriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(OperationTransformerRegistry.class, Map.class, "transformerEntries"));
    static final OperationTransformer FORWARD_TRANSFORMER = new OperationTransformer(){

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    };
    static final OperationTransformer DISCARD_TRANSFORMER = OperationTransformer.DISCARD;
    public static final OperationTransformerEntry DISCARD = new OperationTransformerEntry(DISCARD_TRANSFORMER, true);
    public static final OperationTransformerEntry FORWARD = new OperationTransformerEntry(FORWARD_TRANSFORMER, false);

    protected OperationTransformerRegistry(PathAddressTransformer pathAddressTransformer, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer, boolean placeholder) {
        entriesUpdater.clear(this);
        subRegistriesUpdater.clear(this);
        this.defaultTransformer = defaultTransformer;
        this.resourceTransformer = resourceTransformer;
        this.pathAddressTransformer = pathAddressTransformer;
        this.placeholder = placeholder;
    }

    public TransformerEntry getTransformerEntry(PathAddress address, PlaceholderResolver placeholderResolver) {
        return this.resolveTransformerEntry(address.iterator(), placeholderResolver);
    }

    protected TransformerEntry getTransformerEntry() {
        return new TransformerEntry(){

            @Override
            public PathAddressTransformer getPathTransformation() {
                return OperationTransformerRegistry.this.pathAddressTransformer;
            }

            @Override
            public ResourceTransformer getResourceTransformer() {
                return OperationTransformerRegistry.this.resourceTransformer.getTransformer();
            }
        };
    }

    public ResourceTransformerEntry resolveResourceTransformer(PathAddress address, PlaceholderResolver placeholderResolver) {
        return this.resolveResourceTransformer(address.iterator(), null, placeholderResolver);
    }

    public OperationTransformerEntry resolveOperationTransformer(PathAddress address, String operationName, PlaceholderResolver placeholderResolver) {
        Iterator iterator = address.iterator();
        OperationTransformerEntry entry = this.resolveOperationTransformer(iterator, operationName, placeholderResolver);
        if (entry != null) {
            return entry;
        }
        return FORWARD;
    }

    public void mergeSubsystem(GlobalTransformerRegistry registry, String subsystemName, ModelVersion version) {
        PathElement element = PathElement.pathElement("subsystem", subsystemName);
        registry.mergeSubtree(this, PathAddress.EMPTY_ADDRESS.append(element), version);
    }

    public List<PathAddressTransformer> getPathTransformations(PathAddress address, PlaceholderResolver placeholderResolver) {
        ArrayList<PathAddressTransformer> list = new ArrayList<PathAddressTransformer>();
        Iterator iterator = address.iterator();
        this.resolvePathTransformers(iterator, list, placeholderResolver);
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                iterator.next();
                list.add(PathAddressTransformer.DEFAULT);
            }
        }
        return list;
    }

    public OperationTransformerRegistry getChild(PathAddress address) {
        Iterator iterator = address.iterator();
        return this.resolveChild(iterator);
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    private TransformerEntry resolveTransformerEntry(Iterator<PathElement> iterator, PlaceholderResolver placeholderResolver) {
        if (!iterator.hasNext()) {
            if (this.placeholder && placeholderResolver != null) {
                return placeholderResolver.resolveTransformerEntry(iterator);
            }
            return this.getTransformerEntry();
        }
        PathElement element = iterator.next();
        SubRegistry sub = subRegistriesUpdater.get(this, element.getKey());
        if (sub == null) {
            return null;
        }
        OperationTransformerRegistry registry = sub.get(element.getValue());
        if (registry == null) {
            return null;
        }
        if (registry.placeholder) {
            return placeholderResolver != null ? placeholderResolver.resolveTransformerEntry(iterator) : registry.getTransformerEntry();
        }
        return registry.resolveTransformerEntry(iterator, placeholderResolver);
    }

    ResourceTransformerEntry getResourceTransformer() {
        return this.resourceTransformer;
    }

    private OperationTransformerRegistry resolveChild(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        SubRegistry sub = subRegistriesUpdater.get(this, element.getKey());
        if (sub == null) {
            return null;
        }
        return sub.get(element.getValue(), iterator);
    }

    private void resolvePathTransformers(Iterator<PathElement> iterator, List<PathAddressTransformer> list, PlaceholderResolver placeholderResolver) {
        if (iterator.hasNext()) {
            OperationTransformerRegistry reg;
            PathElement element = iterator.next();
            SubRegistry sub = subRegistriesUpdater.get(this, element.getKey());
            if (sub != null && (reg = sub.get(element.getValue())) != null) {
                list.add(reg.getPathAddressTransformer());
                if (reg.isPlaceholder() && placeholderResolver != null) {
                    placeholderResolver.resolvePathTransformers(iterator, list);
                } else {
                    reg.resolvePathTransformers(iterator, list, placeholderResolver);
                }
                return;
            }
            list.add(PathAddressTransformer.DEFAULT);
            return;
        }
    }

    PathAddressTransformer getPathAddressTransformer() {
        return this.pathAddressTransformer;
    }

    void registerTransformer(PathAddress address, String operationName, OperationTransformer transformer) {
        this.registerTransformer(address.iterator(), operationName, new OperationTransformerEntry(transformer, false));
    }

    public OperationTransformerEntry getDefaultTransformer() {
        return this.defaultTransformer;
    }

    Map<String, OperationTransformerEntry> getTransformers() {
        return entriesUpdater.get(this);
    }

    OperationTransformerRegistry createChildRegistry(Iterator<PathElement> iterator, PathAddressTransformer pathAddressTransformer, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer, boolean placeholder) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        return this.getOrCreate(element.getKey()).createChild(iterator, element.getValue(), pathAddressTransformer, resourceTransformer, defaultTransformer, placeholder);
    }

    void registerTransformer(Iterator<PathElement> iterator, String operationName, OperationTransformerEntry entry) {
        if (!iterator.hasNext()) {
            OperationTransformerEntry existing = entriesUpdater.putIfAbsent(this, operationName, entry);
            if (existing != null) {
                throw new IllegalStateException("duplicate transformer " + operationName);
            }
        } else {
            PathElement element = iterator.next();
            this.getOrCreate(element.getKey()).registerTransformer(iterator, element.getValue(), operationName, entry);
        }
    }

    private ResourceTransformerEntry resolveResourceTransformer(Iterator<PathElement> iterator, ResourceTransformerEntry inherited, PlaceholderResolver placeholderResolver) {
        if (!iterator.hasNext()) {
            if (this.resourceTransformer == null) {
                return inherited;
            }
            return this.resourceTransformer;
        }
        ResourceTransformerEntry inheritedEntry = this.resourceTransformer.inherited ? this.resourceTransformer : inherited;
        PathElement element = iterator.next();
        String key = element.getKey();
        SubRegistry registry = subRegistriesUpdater.get(this, key);
        if (registry == null) {
            return inherited;
        }
        return registry.resolveResourceTransformer(iterator, element.getValue(), inheritedEntry, placeholderResolver);
    }

    private OperationTransformerEntry resolveOperationTransformer(Iterator<PathElement> iterator, String operationName, PlaceholderResolver placeholderResolver) {
        if (!iterator.hasNext()) {
            if (this.placeholder && placeholderResolver != null) {
                return placeholderResolver.resolveOperationTransformer(iterator, operationName);
            }
            OperationTransformerEntry entry = entriesUpdater.get(this, operationName);
            if (entry == null) {
                return this.defaultTransformer;
            }
            return entry;
        }
        PathElement element = iterator.next();
        String key = element.getKey();
        SubRegistry sub = subRegistriesUpdater.get(this, key);
        OperationTransformerEntry entry = null;
        if (sub != null) {
            OperationTransformerRegistry registry = sub.get(element.getValue());
            if (registry != null) {
                entry = registry.placeholder ? (placeholderResolver != null ? placeholderResolver.resolveOperationTransformer(iterator, operationName) : registry.getDefaultTransformer()) : registry.resolveOperationTransformer(iterator, operationName, placeholderResolver);
            }
            if (entry != null) {
                return entry;
            }
        }
        if ((entry = entriesUpdater.get(this, operationName)) != null && entry.isInherited()) {
            return entry;
        }
        entry = this.defaultTransformer;
        if (entry != null && entry.isInherited()) {
            return entry;
        }
        return null;
    }

    private SubRegistry getOrCreate(String key) {
        Map<String, SubRegistry> subRegistries = subRegistriesUpdater.get(this);
        SubRegistry registry = subRegistries.get(key);
        if (registry != null) {
            return registry;
        }
        registry = new SubRegistry();
        if (subRegistriesUpdater.putAtomic(this, key, registry, subRegistries)) {
            return registry;
        }
        return registry;
    }

    public static class OperationTransformerEntry {
        final OperationTransformer transformer;
        final boolean inherited;

        public OperationTransformerEntry(OperationTransformer transformer, boolean inherited) {
            this.transformer = transformer;
            this.inherited = inherited;
        }

        public OperationTransformer getTransformer() {
            return this.transformer;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }

    public static class ResourceTransformerEntry {
        private final ResourceTransformer transformer;
        private final boolean inherited;

        public ResourceTransformerEntry(ResourceTransformer transformer, boolean inherited) {
            this.transformer = transformer;
            this.inherited = inherited;
        }

        public ResourceTransformer getTransformer() {
            return this.transformer;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }

    public static interface PlaceholderResolver {
        public OperationTransformerEntry resolveOperationTransformer(Iterator<PathElement> var1, String var2);

        public void resolvePathTransformers(Iterator<PathElement> var1, List<PathAddressTransformer> var2);

        public TransformerEntry resolveTransformerEntry(Iterator<PathElement> var1);
    }

    private static class SubRegistry {
        private static final AtomicMapFieldUpdater<SubRegistry, String, OperationTransformerRegistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(SubRegistry.class, Map.class, "entries"));
        private volatile Map<String, OperationTransformerRegistry> entries;

        private SubRegistry() {
            childrenUpdater.clear(this);
        }

        private OperationTransformerRegistry createChild(Iterator<PathElement> iterator, String value, PathAddressTransformer pathAddressTransformer, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer, boolean placeholder) {
            if (!iterator.hasNext()) {
                return this.create(value, pathAddressTransformer, resourceTransformer, defaultTransformer, placeholder);
            }
            OperationTransformerRegistry entry = this.get(value);
            if (entry == null) {
                entry = this.create(value, PathAddressTransformer.DEFAULT, GlobalTransformerRegistry.RESOURCE_TRANSFORMER, FORWARD, placeholder);
            }
            return entry.createChildRegistry(iterator, pathAddressTransformer, resourceTransformer, defaultTransformer, placeholder);
        }

        private void registerTransformer(Iterator<PathElement> iterator, String value, String operationName, OperationTransformerEntry entry) {
            this.get(value).registerTransformer(iterator, operationName, entry);
        }

        private OperationTransformerRegistry get(String value) {
            OperationTransformerRegistry entry = childrenUpdater.get(this, value);
            if (entry == null && (entry = childrenUpdater.get(this, "*")) == null) {
                return null;
            }
            return entry;
        }

        private OperationTransformerRegistry get(String value, Iterator<PathElement> iterator) {
            OperationTransformerRegistry entry = childrenUpdater.get(this, value);
            if (entry == null && (entry = childrenUpdater.get(this, "*")) == null) {
                return null;
            }
            return entry.resolveChild(iterator);
        }

        private OperationTransformerRegistry create(String value, PathAddressTransformer pathAddressTransformer, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer, boolean placeholder) {
            Map<String, OperationTransformerRegistry> entries;
            OperationTransformerRegistry entry;
            do {
                if ((entry = (entries = childrenUpdater.get(this)).get(value)) == null) continue;
                return entry;
            } while (!childrenUpdater.putAtomic(this, value, entry = new OperationTransformerRegistry(pathAddressTransformer, resourceTransformer, defaultTransformer, placeholder), entries));
            return entry;
        }

        private ResourceTransformerEntry resolveResourceTransformer(Iterator<PathElement> iterator, String value, ResourceTransformerEntry inheritedEntry, PlaceholderResolver placeholderResolver) {
            OperationTransformerRegistry registry = this.get(value);
            if (registry == null) {
                return inheritedEntry;
            }
            return registry.resolveResourceTransformer(iterator, inheritedEntry, placeholderResolver);
        }
    }
}

