/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.core.embedded.spi.EmbeddedProcessState;

public class ControlledProcessStateService
implements ProcessStateNotifier,
org.wildfly.core.embedded.spi.ProcessStateNotifier {
    @Deprecated(forRemoval=true)
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"controlled-process-state"});
    public static final ServiceName INTERNAL_SERVICE_NAME = AbstractControllerService.PROCESS_STATE_NOTIFIER_CAPABILITY.getCapabilityServiceName();
    private ControlledProcessState.State processState;
    private final PropertyChangeSupport changeSupport;
    private final boolean embedded;

    public static ProcessStateNotifier addService(ServiceTarget target, ControlledProcessState processState) {
        ControlledProcessStateService notifier = processState.getService();
        ServiceBuilder sb = target.addService();
        Consumer consumer = sb.provides(new ServiceName[]{INTERNAL_SERVICE_NAME, SERVICE_NAME, org.wildfly.core.embedded.spi.ProcessStateNotifier.SERVICE_NAME});
        sb.setInstance(Service.newInstance((Consumer)consumer, (Object)notifier));
        sb.install();
        return notifier;
    }

    ControlledProcessStateService(ControlledProcessState.State initialState, boolean embedded) {
        this.processState = initialState;
        this.changeSupport = new PropertyChangeSupport(this);
        this.embedded = embedded;
    }

    @Override
    public ControlledProcessState.State getCurrentState() {
        return this.processState;
    }

    public EmbeddedProcessState getEmbeddedProcessState() {
        this.checkEmbedded();
        return this.processState.getEmbeddedProcessState();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener("currentState", listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener("currentState", listener);
    }

    public void addProcessStateListener(PropertyChangeListener listener) {
        this.checkEmbedded();
        this.changeSupport.addPropertyChangeListener("embeddedState", listener);
    }

    public void removeProcessStateListener(PropertyChangeListener listener) {
        this.checkEmbedded();
        this.changeSupport.removePropertyChangeListener("embeddedState", listener);
    }

    synchronized void stateChanged(ControlledProcessState.State newState) {
        ControlledProcessState.State oldState = this.processState;
        this.processState = newState;
        this.changeSupport.firePropertyChange("currentState", (Object)oldState, (Object)newState);
        this.changeSupport.firePropertyChange("embeddedState", oldState.getEmbeddedProcessState(), newState.getEmbeddedProcessState());
    }

    private void checkEmbedded() {
        if (!this.embedded) {
            throw new IllegalStateException();
        }
    }
}

