/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics.deployment;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricCollector;
import org.wildfly.extension.metrics.MetricRegistration;
import org.wildfly.extension.metrics.MetricRegistry;
import org.wildfly.extension.metrics.MetricsSubsystemDefinition;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.subsystem.service.AsyncServiceBuilder;

public class DeploymentMetricService
implements Service {
    private final Resource rootResource;
    private final ManagementResourceRegistration managementResourceRegistration;
    private PathAddress deploymentAddress;
    private final Supplier<MetricCollector> metricCollector;
    private Supplier<MetricRegistry> metricRegistry;
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private final String prefix;
    private MetricRegistration registration;

    public static void install(RequirementServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Resource rootResource, ManagementResourceRegistration managementResourceRegistration, boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        PathAddress deploymentAddress = DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit);
        AsyncServiceBuilder sb = new AsyncServiceBuilder(serviceTarget.addService(), AsyncServiceBuilder.Async.START_ONLY);
        Supplier metricCollector = sb.requires(MetricsSubsystemDefinition.WILDFLY_COLLECTOR);
        Supplier metricRegistry = sb.requires(MetricsSubsystemDefinition.METRICS_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        sb.requires(DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName()));
        sb.setInstance((Service)new DeploymentMetricService(rootResource, managementResourceRegistration, deploymentAddress, metricCollector, metricRegistry, exposeAnySubsystem, exposedSubsystems, prefix)).install();
    }

    private DeploymentMetricService(Resource rootResource, ManagementResourceRegistration managementResourceRegistration, PathAddress deploymentAddress, Supplier<MetricCollector> metricCollector, Supplier<MetricRegistry> metricRegistry, boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        this.rootResource = rootResource;
        this.managementResourceRegistration = managementResourceRegistration;
        this.deploymentAddress = deploymentAddress;
        this.metricCollector = metricCollector;
        this.metricRegistry = metricRegistry;
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
        this.prefix = prefix;
    }

    public void start(StartContext startContext) {
        this.registration = new MetricRegistration(this.metricRegistry.get());
        this.metricCollector.get().collectResourceMetrics(this.rootResource, (ImmutableManagementResourceRegistration)this.managementResourceRegistration, address -> this.deploymentAddress.append(address), this.exposeAnySubsystem, this.exposedSubsystems, this.prefix, this.registration);
    }

    public void stop(StopContext stopContext) {
        this.registration.unregister();
    }

    private static PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)((String)deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME)));
        }
        return DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }
}

