/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.Response;
import org.jgroups.protocols.RSVP;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.DefaultContextualizerFactory;
import org.wildfly.clustering.function.Callable;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.JChannelGroup;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherContext;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherMarshaller;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherRequestCorrelator;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcher;
import org.wildfly.clustering.server.jgroups.dispatcher.ServiceResponse;
import org.wildfly.clustering.server.util.BlockingExecutor;

public class JChannelCommandDispatcherFactory
implements ChannelCommandDispatcherFactory,
RequestHandler,
Runnable {
    private static final System.Logger LOGGER = System.getLogger(JChannelCommandDispatcherFactory.class.getName());
    private static final Callable<Object> NO_SUCH_SERVICE_CALLER = Callable.of((Object)((Object)ServiceResponse.NO_SUCH_SERVICE));
    private final JChannelGroup group;
    private final Map<Object, CommandDispatcherContext<?, ?>> contexts = new ConcurrentHashMap();
    private final BlockingExecutor executor = BlockingExecutor.newInstance((Runnable)this);
    private final ByteBufferMarshaller marshaller;
    private final MessageDispatcher dispatcher;
    private final Duration timeout;
    private final Function<ClassLoader, ByteBufferMarshaller> marshallerFactory;

    public JChannelCommandDispatcherFactory(Configuration config) {
        this.marshaller = config.getMarshaller();
        this.marshallerFactory = config.getMarshallerFactory();
        JChannel channel = config.getChannel();
        ProtocolStack stack = channel.getProtocolStack();
        RSVP rsvp = (RSVP)stack.findProtocol(RSVP.class);
        this.timeout = Duration.ofMillis(rsvp != null ? rsvp.getTimeout() : stack.getTransport().getWhoHasCacheTimeout());
        this.group = new JChannelGroup(channel);
        CommandDispatcherRequestCorrelator correlator = new CommandDispatcherRequestCorrelator(channel, this, config);
        this.dispatcher = new MessageDispatcher().setChannel(channel).setRequestHandler((RequestHandler)this).setReceiver((Receiver)this.group).asyncDispatching(true).correlator((RequestCorrelator)correlator);
    }

    @Override
    public void run() {
        this.dispatcher.stop();
        this.dispatcher.getChannel().setUpHandler(null);
        this.group.close();
    }

    @Override
    public void close() {
        this.executor.close();
    }

    public Object handle(Message request) throws Exception {
        return this.read(request).call();
    }

    public void handle(Message request, final Response response) throws Exception {
        final Callable<Object> commandTask = this.read(request);
        Runnable responseTask = new Runnable(){

            @Override
            public void run() {
                try {
                    response.send(commandTask.call(), false);
                }
                catch (Throwable e) {
                    response.send((Object)e, true);
                }
            }
        };
        try {
            this.dispatcher.getChannel().getProtocolStack().getTransport().getThreadPool().getThreadPool().execute(responseTask);
        }
        catch (RejectedExecutionException e) {
            response.send((Object)ServiceResponse.NO_SUCH_SERVICE, false);
        }
    }

    private Callable<Object> read(Message message) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(message.getArray(), message.getOffset(), message.getLength());
        Map.Entry entry = (Map.Entry)this.marshaller.read(buffer);
        Object id = entry.getKey();
        final CommandDispatcherContext<?, ?> context = this.contexts.get(id);
        if (context == null) {
            return NO_SUCH_SERVICE_CALLER;
        }
        final Object commandContext = context.getCommandContext();
        final Contextualizer contextualizer = context.getContextualizer();
        MarshalledValue value = (MarshalledValue)entry.getValue();
        final Command command = (Command)value.get(context.getMarshalledValueFactory().getMarshallingContext());
        LOGGER.log(System.Logger.Level.TRACE, "{0} received {1} command on {2}", id, command, this.group.getLocalMember());
        Callable<Object> commandExecutionTask = new Callable<Object>(){

            public Object call() throws Exception {
                return context.getMarshalledValueFactory().createMarshalledValue(command.execute(commandContext));
            }
        };
        final BlockingExecutor executor = this.executor;
        return new Callable<Object>((Callable)commandExecutionTask){
            final /* synthetic */ Callable val$commandExecutionTask;
            {
                this.val$commandExecutionTask = callable;
            }

            public Object call() throws Exception {
                return executor.execute(contextualizer.contextualize((java.util.concurrent.Callable)this.val$commandExecutionTask)).orElse(ServiceResponse.NO_SUCH_SERVICE);
            }
        };
    }

    @Override
    public ChannelGroup getGroup() {
        return this.group;
    }

    public <C> CommandDispatcher<ChannelGroupMember, C> createCommandDispatcher(final Object id, final C commandContext, ClassLoader loader) {
        final ByteBufferMarshaller dispatcherMarshaller = this.marshallerFactory.apply(loader);
        ByteBufferMarshalledValueFactory factory = new ByteBufferMarshalledValueFactory(dispatcherMarshaller);
        final Contextualizer contextualizer = DefaultContextualizerFactory.INSTANCE.createContextualizer(loader);
        CommandDispatcherContext context = new CommandDispatcherContext<C, ByteBufferMarshaller>((MarshalledValueFactory)factory){
            final /* synthetic */ MarshalledValueFactory val$factory;
            {
                this.val$factory = marshalledValueFactory;
            }

            @Override
            public C getCommandContext() {
                return commandContext;
            }

            @Override
            public Contextualizer getContextualizer() {
                return contextualizer;
            }

            @Override
            public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                return this.val$factory;
            }
        };
        if (this.contexts.putIfAbsent(id, context) != null) {
            throw new IllegalArgumentException(id.toString());
        }
        final CommandDispatcherMarshaller commandMarshaller = new CommandDispatcherMarshaller(this.marshaller, id, factory);
        final MessageDispatcher dispatcher = this.dispatcher;
        final JChannelGroup group = this.group;
        final Duration timeout = this.timeout;
        final Runnable closeTask = () -> this.contexts.remove(id);
        return new JChannelCommandDispatcher(new JChannelCommandDispatcher.Configuration<C, Object>(){

            @Override
            public Object getId() {
                return id;
            }

            @Override
            public C getCommandExecutionContext() {
                return commandContext;
            }

            @Override
            public MessageDispatcher getMessageDispatcher() {
                return dispatcher;
            }

            @Override
            public CommandMarshaller<C> getCommandMarshaller() {
                return commandMarshaller;
            }

            @Override
            public ByteBufferMarshaller getMarshallingContext() {
                return dispatcherMarshaller;
            }

            @Override
            public ChannelGroup getGroup() {
                return group;
            }

            @Override
            public Duration getCommandExecutionTimeout() {
                return timeout;
            }

            @Override
            public Runnable getCloseTask() {
                return closeTask;
            }
        });
    }

    public static interface Configuration {
        public Predicate<Message> getUnknownForkPredicate();

        public JChannel getChannel();

        public ByteBufferMarshaller getMarshaller();

        public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory();
    }
}

