/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandMarshaller;

public class CommandDispatcherMarshaller<CC, MC>
implements CommandMarshaller<CC> {
    private final ByteBufferMarshaller marshaller;
    private final Object id;
    private final MarshalledValueFactory<MC> factory;

    public CommandDispatcherMarshaller(ByteBufferMarshaller marshaller, Object id, MarshalledValueFactory<MC> factory) {
        this.marshaller = marshaller;
        this.id = id;
        this.factory = factory;
    }

    @Override
    public <R, E extends Exception> ByteBuffer marshal(Command<R, ? super CC, E> command) throws IOException {
        MarshalledValue value = this.factory.createMarshalledValue(command);
        AbstractMap.SimpleImmutableEntry<Object, MarshalledValue> entry = new AbstractMap.SimpleImmutableEntry<Object, MarshalledValue>(this.id, value);
        return this.marshaller.write(entry);
    }
}

