/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service.descriptor;

import java.util.Map;
import org.wildfly.service.descriptor.ServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public interface BinaryServiceDescriptor<T>
extends ServiceDescriptor<T> {
    default public Map.Entry<String, String[]> resolve(String parent, String child) {
        return parent != null && child != null ? Map.entry(this.getName(), new String[]{parent, child}) : null;
    }

    @Override
    default public <U extends T> BinaryServiceDescriptor<U> asType(final Class<U> type) {
        return new BinaryServiceDescriptor<U>(){

            @Override
            public String getName() {
                return BinaryServiceDescriptor.this.getName();
            }

            @Override
            public Class<U> getType() {
                return type;
            }

            @Override
            public Map.Entry<String, String[]> resolve(String parent, String child) {
                return BinaryServiceDescriptor.this.resolve(parent, child);
            }
        };
    }

    public static <T> BinaryServiceDescriptor<T> of(final String name, final Class<T> type) {
        return new BinaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return type;
            }
        };
    }

    public static <T> BinaryServiceDescriptor<T> of(final String name, final UnaryServiceDescriptor<T> defaultDescriptor) {
        return new BinaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return defaultDescriptor.getType();
            }

            @Override
            public Map.Entry<String, String[]> resolve(String parent, String child) {
                return child != null ? BinaryServiceDescriptor.super.resolve(parent, child) : defaultDescriptor.resolve(parent);
            }
        };
    }

    public static interface Provider<T>
    extends ServiceDescriptor.Provider<T, BinaryServiceDescriptor<T>>,
    BinaryServiceDescriptor<T> {
        @Override
        default public Map.Entry<String, String[]> resolve(String parent, String child) {
            return ((BinaryServiceDescriptor)this.get()).resolve(parent, child);
        }
    }
}

