/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.crypto.Cipher;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.CredentialReferenceAttributeDefinition;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.service.ServiceDependency;

public class CipherAuthTokenResourceDefinitionRegistrar
extends AuthTokenResourceDefinitionRegistrar<CipherAuthToken> {
    static final CredentialReferenceAttributeDefinition KEY_CREDENTIAL = new CredentialReferenceAttributeDefinition.Builder("key-credential-reference", CAPABILITY).build();
    static final CapabilityReferenceAttributeDefinition<KeyStore> KEY_STORE = new CapabilityReferenceAttributeDefinition.Builder("key-store", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE).build()).build();

    CipherAuthTokenResourceDefinitionRegistrar() {
        super(AuthTokenResourceDefinitionRegistrar.Token.CIPHER);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addAttribute((AttributeDefinition)KEY_CREDENTIAL, CredentialReferenceWriteAttributeHandler.INSTANCE)).addAttributes(List.of(KEY_STORE))).provideAttributes(EnumSet.allOf(Attribute.class));
    }

    public ServiceDependency<Function<byte[], CipherAuthToken>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String keyAlias = Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final String transformation = Attribute.ALGORITHM.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return KEY_STORE.resolve(context, model).combine((Dependency)KEY_CREDENTIAL.resolve(context, model).map(CLEAR_PASSWORD_CREDENTIAL), (BiFunction)new BiFunction<KeyStore, char[], Function<byte[], CipherAuthToken>>(){

            @Override
            public Function<byte[], CipherAuthToken> apply(final KeyStore store, final char[] password) {
                return new Function<byte[], CipherAuthToken>(){

                    @Override
                    public CipherAuthToken apply(byte[] secret) {
                        try {
                            if (!store.containsAlias(keyAlias)) {
                                throw JGroupsLogger.ROOT_LOGGER.keyEntryNotFound(keyAlias);
                            }
                            if (!store.entryInstanceOf(keyAlias, KeyStore.PrivateKeyEntry.class)) {
                                throw JGroupsLogger.ROOT_LOGGER.unexpectedKeyStoreEntryType(keyAlias, KeyStore.PrivateKeyEntry.class.getSimpleName());
                            }
                            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(keyAlias, new KeyStore.PasswordProtection(password));
                            KeyPair pair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
                            Cipher cipher = Cipher.getInstance(transformation);
                            return new CipherAuthToken(cipher, pair, secret);
                        }
                        catch (GeneralSecurityException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                };
            }
        });
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        KEY_ALIAS("key-alias", ModelType.STRING, null),
        ALGORITHM("algorithm", ModelType.STRING, new ModelNode("RSA"));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(defaultValue == null)).setAllowExpression(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

