/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleManagement
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SIMPLE_OPTIONS = "{\"field\":\"\",\"value\":\"\",\"operation\":\"\"}";
    String uri;
    String user;
    String password;
    ServerLocator locator;
    ClientSessionFactory sessionFactory;
    ClientSession session;

    public SimpleManagement(String uri, String user, String password) {
        this.uri = uri;
        this.user = user;
        this.password = password;
    }

    public SimpleManagement open() throws Exception {
        if (this.session == null) {
            this.locator = ServerLocatorImpl.newLocator(this.uri);
            this.sessionFactory = this.locator.createSessionFactory();
            this.session = this.sessionFactory.createSession(this.user, this.password, false, true, true, false, 0x100000);
        }
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public void setSession(ClientSession session) {
        this.session = session;
    }

    @Override
    public void close() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.locator != null) {
            this.locator.close();
            this.locator = null;
        }
    }

    public long getCurrentTimeMillis() throws Exception {
        return this.simpleManagementLong("broker", "getCurrentTimeMillis", new Object[0]);
    }

    public boolean isReplicaSync() throws Exception {
        return this.simpleManagementBoolean("broker", "isReplicaSync", new Object[0]);
    }

    public void rebuildPageCounters() throws Exception {
        this.simpleManagementVoid("broker", "rebuildPageCounters", new Object[0]);
    }

    public String simpleManagement(String resource, String method, Object ... parameters) throws Exception {
        AtomicReference responseString = new AtomicReference();
        this.doManagement(m -> SimpleManagement.setupCall(m, resource, method, parameters), m -> SimpleManagement.setStringResult(m, responseString), SimpleManagement::failed);
        return (String)responseString.get();
    }

    public long simpleManagementLong(String resource, String method, Object ... parameters) throws Exception {
        AtomicLong responseLong = new AtomicLong();
        this.doManagement(m -> SimpleManagement.setupCall(m, resource, method, parameters), m -> SimpleManagement.setLongResult(m, responseLong), SimpleManagement::failed);
        return responseLong.get();
    }

    public boolean simpleManagementBoolean(String resource, String method, Object ... parameters) throws Exception {
        AtomicBoolean responseBoolean = new AtomicBoolean();
        this.doManagement(m -> SimpleManagement.setupCall(m, resource, method, parameters), m -> SimpleManagement.setBooleanResult(m, responseBoolean), SimpleManagement::failed);
        return responseBoolean.get();
    }

    public void simpleManagementVoid(String resource, String method, Object ... parameters) throws Exception {
        this.doManagement(m -> SimpleManagement.setupCall(m, resource, method, parameters), null, SimpleManagement::failed);
    }

    public int simpleManagementInt(String resource, String method, Object ... parameters) throws Exception {
        AtomicInteger responseInt = new AtomicInteger();
        this.doManagement(m -> SimpleManagement.setupCall(m, resource, method, parameters), m -> SimpleManagement.setIntResult(m, responseInt), SimpleManagement::failed);
        return responseInt.get();
    }

    public long getMessageCountOnQueue(String queueName) throws Exception {
        return this.simpleManagementLong("queue." + queueName, "getMessageCount", new Object[0]);
    }

    public long getMessageAddedOnQueue(String queueName) throws Exception {
        return this.simpleManagementLong("queue." + queueName, "getMessagesAdded", new Object[0]);
    }

    public int getDeliveringCountOnQueue(String queueName) throws Exception {
        return this.simpleManagementInt("queue." + queueName, "getDeliveringCount", new Object[0]);
    }

    public int getNumberOfConsumersOnQueue(String queueName) throws Exception {
        String responseString = this.simpleManagement("queue." + queueName, "listConsumersAsJSON", new Object[0]);
        JsonArray consumersAsJSON = JsonUtil.readJsonArray(responseString);
        return consumersAsJSON.size();
    }

    public long getMessagesAddedOnQueue(String queueName) throws Exception {
        return this.simpleManagementLong("queue." + queueName, "getMessagesAdded", new Object[0]);
    }

    public Map<String, Long> getQueueCounts(int maxRows) throws Exception {
        String responseString = this.simpleManagement("broker", "listQueues", SIMPLE_OPTIONS, 1, maxRows);
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject(responseString);
        JsonArray array = queuesAsJsonObject.getJsonArray("data");
        HashMap<String, Long> queues = new HashMap<String, Long>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject object = array.getJsonObject(i);
            String name = object.getString("name");
            String messageCount = object.getString("messageCount");
            queues.put(name, Long.parseLong(messageCount));
        }
        return queues;
    }

    public String getNodeID() throws Exception {
        return this.simpleManagement("broker", "getNodeID", new Object[0]);
    }

    public JsonArray listNetworkTopology() throws Exception {
        String result = this.simpleManagement("broker", "listNetworkTopology", new Object[0]);
        return JsonUtil.readJsonArray(result);
    }

    protected static void failed(ClientMessage message) throws Exception {
        String result = (String)ManagementHelper.getResult(message, String.class);
        logger.warn("simple management operation failed:: {}", (Object)result);
        throw new Exception("Failed " + result);
    }

    protected static void setupCall(ClientMessage m, String resource, String methodName, Object ... parameters) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up call {}::{}::{}", resource, methodName, parameters);
        }
        ManagementHelper.putOperationInvocation(m, resource, methodName, parameters);
    }

    protected static void setStringResult(ClientMessage m, AtomicReference<String> result) throws Exception {
        String resultString = (String)ManagementHelper.getResult(m, String.class);
        logger.debug("management result:: {}", (Object)resultString);
        result.set(resultString);
    }

    protected static void setLongResult(ClientMessage m, AtomicLong result) throws Exception {
        long resultLong = (Long)ManagementHelper.getResult(m, Long.class);
        logger.debug("management result:: {}", (Object)resultLong);
        result.set(resultLong);
    }

    protected static void setBooleanResult(ClientMessage m, AtomicBoolean result) throws Exception {
        boolean resultBoolean = (Boolean)ManagementHelper.getResult(m, Boolean.class);
        logger.debug("management result:: {}", (Object)resultBoolean);
        result.set(resultBoolean);
    }

    protected static void setIntResult(ClientMessage m, AtomicInteger result) throws Exception {
        int resultInt = (Integer)ManagementHelper.getResult(m, Integer.class);
        logger.debug("management result:: {}", (Object)resultInt);
        result.set(resultInt);
    }

    protected void doManagement(ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        if (this.session != null) {
            ManagementHelper.doManagement(this.session, setup, ok, failed);
        } else {
            ManagementHelper.doManagement(this.uri, this.user, this.password, setup, ok, failed);
        }
    }
}

