/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.WildFlyManagedExecutorService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.concurrent.adapter.ManagedExecutorServiceAdapter;
import org.jboss.as.ee.concurrent.service.DelegatingSupplier;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.concurrent.service.ManagedExecutorHungTasksPeriodicTerminationService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;

public class ManagedExecutorServiceService
extends EEConcurrentAbstractService<ManagedExecutorServiceAdapter> {
    private volatile ManagedExecutorServiceAdapter executorService;
    private final Consumer<ManagedExecutorServiceAdapter> consumer;
    private final String name;
    private final Supplier<WildFlyManagedThreadFactory> managedThreadFactorySupplier;
    private final long hungTaskThreshold;
    private final long hungTaskTerminationPeriod;
    private final boolean longRunningTasks;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long keepAliveTime;
    private final TimeUnit keepAliveTimeUnit;
    private final long threadLifeTime;
    private final int queueCapacity;
    private final DelegatingSupplier<WildFlyContextService> contextServiceSupplier = new DelegatingSupplier();
    private final WildFlyManagedExecutorService.RejectPolicy rejectPolicy;
    private final Integer threadPriority;
    private final Supplier<ProcessStateNotifier> processStateNotifierSupplier;
    private final Supplier<RequestController> requestControllerSupplier;
    private ControlPoint controlPoint;
    private final Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService;
    private Future hungTasksPeriodicTerminationFuture;

    public ManagedExecutorServiceService(Consumer<ManagedExecutorServiceAdapter> consumer, Supplier<WildFlyContextService> contextServiceSupplier, Supplier<WildFlyManagedThreadFactory> managedThreadFactorySupplier, Supplier<ProcessStateNotifier> processStateNotifierSupplier, Supplier<RequestController> requestControllerSupplier, String name, String jndiName, long hungTaskThreshold, long hungTaskTerminationPeriod, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, WildFlyManagedExecutorService.RejectPolicy rejectPolicy, Integer threadPriority, Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService) {
        super(jndiName);
        this.consumer = consumer;
        this.contextServiceSupplier.set(contextServiceSupplier);
        this.managedThreadFactorySupplier = managedThreadFactorySupplier;
        this.processStateNotifierSupplier = processStateNotifierSupplier;
        this.requestControllerSupplier = requestControllerSupplier;
        this.name = name;
        this.hungTaskThreshold = hungTaskThreshold;
        this.hungTaskTerminationPeriod = hungTaskTerminationPeriod;
        this.longRunningTasks = longRunningTasks;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeUnit = keepAliveTimeUnit;
        this.threadLifeTime = threadLifeTime;
        this.queueCapacity = queueCapacity;
        this.rejectPolicy = rejectPolicy;
        this.threadPriority = threadPriority;
        this.hungTasksPeriodicTerminationService = hungTasksPeriodicTerminationService;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        WildFlyManagedThreadFactory managedThreadFactory;
        int priority;
        if (this.threadPriority != null) {
            priority = this.threadPriority;
        } else {
            managedThreadFactory = this.managedThreadFactorySupplier != null ? this.managedThreadFactorySupplier.get() : null;
            priority = managedThreadFactory != null ? managedThreadFactory.getPriority() : 5;
        }
        managedThreadFactory = ConcurrencyImplementation.INSTANCE.newManagedThreadFactory("EE-ManagedExecutorService-" + this.name, null, priority);
        if (this.requestControllerSupplier != null) {
            RequestController requestController = this.requestControllerSupplier.get();
            this.controlPoint = requestController != null ? requestController.getControlPoint(this.name, "managed-executor-service") : null;
        }
        this.executorService = new ManagedExecutorServiceAdapter(ConcurrencyImplementation.INSTANCE.newManagedExecutorService(this.name, managedThreadFactory, this.hungTaskThreshold, this.longRunningTasks, this.corePoolSize, this.maxPoolSize, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, this.queueCapacity, this.contextServiceSupplier != null ? this.contextServiceSupplier.get() : null, this.rejectPolicy, this.controlPoint, this.processStateNotifierSupplier.get()));
        if (this.hungTaskThreshold > 0L && this.hungTaskTerminationPeriod > 0L) {
            this.hungTasksPeriodicTerminationFuture = this.hungTasksPeriodicTerminationService.get().startHungTaskPeriodicTermination(this.executorService.getExecutorService(), this.hungTaskTerminationPeriod);
        }
        this.consumer.accept(this.executorService);
    }

    @Override
    void stopValue(StopContext context) {
        if (this.executorService != null) {
            if (this.hungTasksPeriodicTerminationFuture != null) {
                this.hungTasksPeriodicTerminationFuture.cancel(true);
            }
            this.executorService.getExecutorService().shutdownNow();
            this.executorService.getManagedThreadFactory().stop();
            this.executorService = null;
        }
        if (this.controlPoint != null) {
            this.requestControllerSupplier.get().removeControlPoint(this.controlPoint);
        }
        this.consumer.accept(null);
    }

    public ManagedExecutorServiceAdapter getValue() throws IllegalStateException {
        return this.executorService;
    }

    public WildFlyManagedExecutorService getExecutorService() throws IllegalStateException {
        if (this.executorService == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.executorService.getExecutorService();
    }

    public DelegatingSupplier<WildFlyContextService> getContextServiceSupplier() {
        return this.contextServiceSupplier;
    }
}

