/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import jakarta.enterprise.concurrent.ContextService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.jboss.as.ee.concurrent.handle.EE10ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.msc.service.ServiceName;

public class NamingContextHandleFactory
implements EE10ContextHandleFactory {
    private static final NamingContextHandle CLEARED_CONTEXT_HANDLE = new NamingContextHandle(null, null);
    public static final String NAME = "NAMING";
    private final NamespaceContextSelector namespaceContextSelector;
    private final ServiceName duServiceName;

    public NamingContextHandleFactory(NamespaceContextSelector namespaceContextSelector, ServiceName duServiceName) {
        this.namespaceContextSelector = namespaceContextSelector;
        this.duServiceName = duServiceName;
    }

    @Override
    public String getContextType() {
        return "Application";
    }

    @Override
    public SetupContextHandle clearedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return CLEARED_CONTEXT_HANDLE;
    }

    @Override
    public SetupContextHandle propagatedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new NamingContextHandle(this.namespaceContextSelector, this.duServiceName);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 200;
    }

    @Override
    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeBoolean(contextHandle != CLEARED_CONTEXT_HANDLE);
    }

    @Override
    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return in.readBoolean() ? new NamingContextHandle(this.namespaceContextSelector, this.duServiceName) : CLEARED_CONTEXT_HANDLE;
    }

    private static class NamingContextHandle
    implements SetupContextHandle,
    ResetContextHandle {
        private static final long serialVersionUID = -4631099493960707685L;
        private final NamespaceContextSelector namespaceContextSelector;
        private final ServiceName duServiceName;

        private NamingContextHandle(NamespaceContextSelector namespaceContextSelector, ServiceName duServiceName) {
            this.namespaceContextSelector = namespaceContextSelector;
            this.duServiceName = duServiceName;
        }

        @Override
        public String getFactoryName() {
            return NamingContextHandleFactory.NAME;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.namespaceContextSelector);
            WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
            return this;
        }

        @Override
        public void reset() {
            WritableServiceBasedNamingStore.popOwner();
            NamespaceContextSelector.popCurrentSelector();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }
}

