/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.function.CollectionOperations;
import org.wildfly.clustering.cache.function.Operations;

public enum SetOperations implements CollectionOperations<Object, Set<Object>>
{
    HASH(HashSet::new, HashSet::new),
    TREE(TreeSet::new, TreeSet::new);

    private final Supplier<Set<Object>> factory;
    private final UnaryOperator<Set<Object>> copier;

    static <T> Operations<Set<T>> forOperand(T value) {
        SetOperations result = value instanceof Comparable ? TREE : HASH;
        return result.cast();
    }

    private SetOperations(Supplier<Set<Object>> factory, UnaryOperator<Set<Object>> copier) {
        this.factory = factory;
        this.copier = copier;
    }

    @Override
    public UnaryOperator<Set<Object>> getCopier() {
        return this.copier;
    }

    @Override
    public Supplier<Set<Object>> getFactory() {
        return this.factory;
    }

    <T> Operations<Set<T>> cast() {
        return this;
    }
}

