/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.client.ClientResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.naming.ClassLoaderUtils;
import org.wildfly.httpclient.naming.Serializer;
import org.wildfly.naming.client.NamingProvider;
import org.xnio.IoUtils;

final class ClientHandlers {
    private ClientHandlers() {
    }

    static HttpTargetContext.HttpMarshaller objectHttpMarshaller(Marshaller marshaller, Object object) {
        return new ObjectHttpMarshaller(marshaller, object);
    }

    static <T> HttpTargetContext.HttpResultHandler emptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
        return new EmptyHttpResultHandler<T>(result, function);
    }

    static HttpTargetContext.HttpResultHandler optionalObjectHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Object> result, NamingProvider namingProvider, ClassLoader classLoader) {
        return new OptionalObjectHttpResultHandler(unmarshaller, result, namingProvider, classLoader);
    }

    private static HttpTargetContext.HttpResultHandler objectHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Object> result) {
        return new ObjectHttpResultHandler(unmarshaller, result);
    }

    private static final class ObjectHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<Object> result;

        private ObjectHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Object> result) {
            this.unmarshaller = unmarshaller;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try (ByteInput in = ByteInputs.byteInputOf((InputStream)is);){
                this.unmarshaller.start(in);
                Object object = Serializer.deserializeObject((ObjectInput)this.unmarshaller);
                this.unmarshaller.finish();
                this.result.complete(object);
            }
            catch (Exception e) {
                this.result.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class OptionalObjectHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<Object> result;
        private final NamingProvider namingProvider;
        private final ClassLoader classLoader;

        private OptionalObjectHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Object> result, NamingProvider namingProvider, ClassLoader classLoader) {
            this.unmarshaller = unmarshaller;
            this.result = result;
            this.namingProvider = namingProvider;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try {
                this.namingProvider.performExceptionAction((a, b) -> {
                    ClassLoader old = ClassLoaderUtils.setContextClassLoader(this.classLoader);
                    try {
                        if (response.getResponseCode() == 204) {
                            ClientHandlers.emptyHttpResultHandler(this.result, null).handleResult(is, response, doneCallback);
                        } else {
                            ClientHandlers.objectHttpResultHandler(this.unmarshaller, this.result).handleResult(is, response, doneCallback);
                        }
                    }
                    finally {
                        ClassLoaderUtils.setContextClassLoader(old);
                    }
                    return null;
                }, null, null);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class EmptyHttpResultHandler<T>
    implements HttpTargetContext.HttpResultHandler {
        private final CompletableFuture<T> result;
        private final Function<ClientResponse, T> function;

        private EmptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
            this.result = result;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try {
                this.result.complete(this.function != null ? (Object)this.function.apply(response) : null);
            }
            finally {
                IoUtils.safeClose((Closeable)doneCallback);
            }
        }
    }

    private static final class ObjectHttpMarshaller
    implements HttpTargetContext.HttpMarshaller {
        private final Marshaller marshaller;
        private final Object object;

        private ObjectHttpMarshaller(Marshaller marshaller, Object object) {
            this.marshaller = marshaller;
            this.object = object;
        }

        public void marshall(OutputStream os) throws Exception {
            try (ByteOutput out = ByteOutputs.byteOutputOf((OutputStream)os);){
                this.marshaller.start(out);
                Serializer.serializeObject((ObjectOutput)this.marshaller, this.object);
                this.marshaller.finish();
            }
        }
    }
}

