/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.KnnPredicate;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NestedExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PredicateOptimisations;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinBoxExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinCircleExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinPolygonExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;

public final class BooleShannonExpansion {
    private final int maxExpansionCofactors;
    private final IndexedFieldProvider.FieldIndexingMetadata fieldIndexingMetadata;

    public BooleShannonExpansion(int maxExpansionCofactors, IndexedFieldProvider.FieldIndexingMetadata fieldIndexingMetadata) {
        this.maxExpansionCofactors = maxExpansionCofactors;
        this.fieldIndexingMetadata = fieldIndexingMetadata;
    }

    public BooleanExpr expand(BooleanExpr booleanExpr) {
        if (booleanExpr == null || booleanExpr instanceof ConstantBooleanExpr) {
            return booleanExpr;
        }
        UnindexedPredicateCollector collector = new UnindexedPredicateCollector();
        booleanExpr.acceptVisitor(collector);
        if (!collector.foundIndexed) {
            return ConstantBooleanExpr.TRUE;
        }
        if (!collector.predicatesToRemove.isEmpty()) {
            int numCofactors = 1;
            for (PrimaryPredicateExpr e : collector.predicatesToRemove) {
                PredicateReplacer replacer1 = new PredicateReplacer(e, ConstantBooleanExpr.TRUE);
                BooleanExpr e1 = (BooleanExpr)booleanExpr.acceptVisitor(replacer1);
                if (!replacer1.found) continue;
                if (e1 == ConstantBooleanExpr.TRUE) {
                    return ConstantBooleanExpr.TRUE;
                }
                PredicateReplacer replacer2 = new PredicateReplacer(e, ConstantBooleanExpr.FALSE);
                BooleanExpr e2 = (BooleanExpr)booleanExpr.acceptVisitor(replacer2);
                if (e2 == ConstantBooleanExpr.TRUE) {
                    return ConstantBooleanExpr.TRUE;
                }
                if (e1 == ConstantBooleanExpr.FALSE) {
                    booleanExpr = e2;
                } else if (e2 == ConstantBooleanExpr.FALSE) {
                    booleanExpr = e1;
                } else {
                    OrExpr disjunction;
                    numCofactors *= 2;
                    if (e1 instanceof OrExpr) {
                        disjunction = (OrExpr)e1;
                        if (e2 instanceof OrExpr) {
                            disjunction.getChildren().addAll(((OrExpr)e2).getChildren());
                        } else {
                            disjunction.getChildren().add(e2);
                        }
                    } else if (e2 instanceof OrExpr) {
                        disjunction = (OrExpr)e2;
                        disjunction.getChildren().add(e1);
                    } else {
                        disjunction = new OrExpr(e1, e2);
                    }
                    PredicateOptimisations.optimizePredicates(disjunction.getChildren(), false);
                    booleanExpr = disjunction;
                }
                if (numCofactors <= this.maxExpansionCofactors) continue;
                return ConstantBooleanExpr.TRUE;
            }
        }
        return booleanExpr;
    }

    private final class UnindexedPredicateCollector
    extends ExprVisitor {
        private boolean foundIndexed = false;
        private final Set<PrimaryPredicateExpr> predicatesToRemove = new LinkedHashSet<PrimaryPredicateExpr>();

        private UnindexedPredicateCollector() {
        }

        @Override
        public BooleanExpr visit(FullTextBoostExpr fullTextBoostExpr) {
            fullTextBoostExpr.getChild().acceptVisitor(this);
            return fullTextBoostExpr;
        }

        @Override
        public BooleanExpr visit(FullTextOccurExpr fullTextOccurExpr) {
            fullTextOccurExpr.getChild().acceptVisitor(this);
            return fullTextOccurExpr;
        }

        @Override
        public BooleanExpr visit(FullTextTermExpr fullTextTermExpr) {
            this.collect(fullTextTermExpr);
            return fullTextTermExpr;
        }

        @Override
        public BooleanExpr visit(FullTextRegexpExpr fullTextRegexpExpr) {
            this.collect(fullTextRegexpExpr);
            return fullTextRegexpExpr;
        }

        @Override
        public BooleanExpr visit(FullTextRangeExpr fullTextRangeExpr) {
            this.collect(fullTextRangeExpr);
            return fullTextRangeExpr;
        }

        @Override
        public BooleanExpr visit(KnnPredicate knnPredicate) {
            this.foundIndexed = true;
            return knnPredicate;
        }

        @Override
        public BooleanExpr visit(SpatialWithinCircleExpr spatialWithinCircleExpr) {
            this.collect(spatialWithinCircleExpr);
            return spatialWithinCircleExpr;
        }

        @Override
        public BooleanExpr visit(SpatialWithinBoxExpr spatialWithinBoxExpr) {
            this.collect(spatialWithinBoxExpr);
            return spatialWithinBoxExpr;
        }

        @Override
        public BooleanExpr visit(SpatialWithinPolygonExpr spatialWithinPolygonExpr) {
            this.collect(spatialWithinPolygonExpr);
            return super.visit(spatialWithinPolygonExpr);
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            notExpr.getChild().acceptVisitor(this);
            return notExpr;
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            for (BooleanExpr c : orExpr.getChildren()) {
                c.acceptVisitor(this);
            }
            return orExpr;
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            for (BooleanExpr c : andExpr.getChildren()) {
                c.acceptVisitor(this);
            }
            return andExpr;
        }

        @Override
        public BooleanExpr visit(NestedExpr nestedExpr) {
            for (BooleanExpr c : nestedExpr.getChildren()) {
                c.acceptVisitor(this);
            }
            return nestedExpr;
        }

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr;
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            this.collect(isNullExpr);
            return isNullExpr;
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            this.collect(comparisonExpr);
            return comparisonExpr;
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            this.collect(likeExpr);
            return likeExpr;
        }

        @Override
        public BooleanExpr visit(BetweenExpr betweenExpr) {
            this.collect(betweenExpr);
            return betweenExpr;
        }

        @Override
        public ValueExpr visit(ConstantValueExpr constantValueExpr) {
            return constantValueExpr;
        }

        @Override
        public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
            return propertyValueExpr;
        }

        @Override
        public ValueExpr visit(AggregationExpr aggregationExpr) {
            return aggregationExpr;
        }

        private void collect(PrimaryPredicateExpr primaryPredicateExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)primaryPredicateExpr.getChild();
            if (BooleShannonExpansion.this.fieldIndexingMetadata.isSearchable(propertyValueExpr.getPropertyPath().asArrayPath())) {
                this.foundIndexed = true;
            } else {
                this.predicatesToRemove.add(primaryPredicateExpr);
            }
        }
    }

    private static final class PredicateReplacer
    extends ExprVisitor {
        private final PrimaryPredicateExpr toReplace;
        private final ConstantBooleanExpr with;
        private boolean found = false;

        private PredicateReplacer(PrimaryPredicateExpr toReplace, ConstantBooleanExpr with) {
            this.toReplace = toReplace;
            this.with = with;
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            BooleanExpr transformedChild = (BooleanExpr)notExpr.getChild().acceptVisitor(this);
            if (transformedChild instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)transformedChild).negate();
            }
            return new NotExpr(transformedChild);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> newChildren = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr c : orExpr.getChildren()) {
                BooleanExpr e = (BooleanExpr)c.acceptVisitor(this);
                if (e instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)e).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (e instanceof OrExpr) {
                    newChildren.addAll(((OrExpr)e).getChildren());
                    continue;
                }
                newChildren.add(e);
            }
            PredicateOptimisations.optimizePredicates(newChildren, false);
            if (newChildren.size() == 1) {
                return (BooleanExpr)newChildren.get(0);
            }
            return new OrExpr(newChildren);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> newChildren = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr c : andExpr.getChildren()) {
                BooleanExpr e = (BooleanExpr)c.acceptVisitor(this);
                if (e instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)e).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (e instanceof AndExpr) {
                    newChildren.addAll(((AndExpr)e).getChildren());
                    continue;
                }
                newChildren.add(e);
            }
            PredicateOptimisations.optimizePredicates(newChildren, true);
            if (newChildren.size() == 1) {
                return (BooleanExpr)newChildren.get(0);
            }
            return new AndExpr(newChildren);
        }

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr;
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return this.replace(isNullExpr);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            return this.replace(comparisonExpr);
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            return this.replace(likeExpr);
        }

        @Override
        public BooleanExpr visit(SpatialWithinCircleExpr spatialWithinCircleExpr) {
            return this.replace(spatialWithinCircleExpr);
        }

        @Override
        public ValueExpr visit(ConstantValueExpr constantValueExpr) {
            return constantValueExpr;
        }

        @Override
        public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
            return propertyValueExpr;
        }

        @Override
        public ValueExpr visit(AggregationExpr aggregationExpr) {
            return aggregationExpr;
        }

        private BooleanExpr replace(PrimaryPredicateExpr primaryPredicateExpr) {
            switch (PredicateOptimisations.comparePrimaryPredicates(false, primaryPredicateExpr, false, this.toReplace)) {
                case IDENTICAL: {
                    this.found = true;
                    return this.with;
                }
                case OPPOSITE: {
                    this.found = true;
                    return this.with.negate();
                }
            }
            return primaryPredicateExpr;
        }
    }
}

