/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;

    public ScheduledThreadPoolWriteAttributeHandler(RuntimeCapability<Void> capability, ServiceName serviceNameBase) {
        super(ScheduledThreadPoolAdd.ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> service, boolean forRollback) {
        if (!forRollback) {
            throw ThreadsLogger.ROOT_LOGGER.unsupportedScheduledThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = null;
        ServiceController controller = null;
        if (this.capability != null) {
            serviceName = this.capability.getCapabilityServiceName(context.getCurrentAddress());
            controller = context.getServiceRegistry(true).getService(serviceName);
            if (controller != null) {
                return controller;
            }
        }
        if (this.serviceNameBase != null) {
            serviceName = this.serviceNameBase.append(new String[]{name});
            controller = context.getServiceRegistry(true).getService(serviceName);
        }
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.scheduledThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

