/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.EnhancedQueueExecutorService;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolManagementUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BoundedQueueThreadPoolAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] BLOCKING_ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.THREAD_FACTORY, PoolAttributeDefinitions.CORE_THREADS, PoolAttributeDefinitions.QUEUE_LENGTH, PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT};
    static final AttributeDefinition[] NON_BLOCKING_ATTRIBUTES = new AttributeDefinition[BLOCKING_ATTRIBUTES.length + 1];
    private final boolean blocking;
    private final ThreadFactoryResolver threadFactoryResolver;
    private final HandoffExecutorResolver handoffExecutorResolver;
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;

    public BoundedQueueThreadPoolAdd(boolean blocking, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase) {
        this(blocking, threadFactoryResolver, handoffExecutorResolver, serviceNameBase, null);
    }

    public BoundedQueueThreadPoolAdd(boolean blocking, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase, RuntimeCapability<Void> capability) {
        this.blocking = blocking;
        this.threadFactoryResolver = threadFactoryResolver;
        this.handoffExecutorResolver = handoffExecutorResolver;
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolManagementUtils.EnhancedQueueThreadPoolParameters params = ThreadPoolManagementUtils.parseBoundedThreadPoolParameters(context, operation, model, this.blocking);
        EnhancedQueueExecutorService service = new EnhancedQueueExecutorService(params.isAllowCoreTimeout(), params.getMaxThreads(), params.getCoreThreads(), params.getQueueLength(), params.getKeepAliveTime(), this.blocking);
        ThreadPoolManagementUtils.installThreadPoolService(service, params.getName(), this.capability, context.getCurrentAddress(), this.serviceNameBase, params.getThreadFactory(), this.threadFactoryResolver, service.getThreadFactoryInjector(), params.getHandoffExecutor(), this.handoffExecutorResolver, this.blocking ? null : service.getHandoffExecutorInjector(), (ServiceTarget)context.getCapabilityServiceTarget());
    }

    boolean isBlocking() {
        return this.blocking;
    }

    ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    ThreadFactoryResolver getThreadFactoryResolver() {
        return this.threadFactoryResolver;
    }

    HandoffExecutorResolver getHandoffExecutorResolver() {
        return this.handoffExecutorResolver;
    }

    static {
        System.arraycopy(BLOCKING_ATTRIBUTES, 0, NON_BLOCKING_ATTRIBUTES, 0, BLOCKING_ATTRIBUTES.length);
        BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES[BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES.length - 1] = PoolAttributeDefinitions.HANDOFF_EXECUTOR;
    }
}

