/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.ConcatIterator;
import org.infinispan.commons.util.FlattenSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableCaffeineMap;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.wildfly.clustering.cache.caffeine.CacheConfiguration;
import org.wildfly.clustering.cache.caffeine.CacheFactory;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;

public class SegmentedEvictableDataContainer<K, V>
extends DefaultSegmentedDataContainer<K, V> {
    private final Executor executor;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;
    private final PeekableTouchableMap<K, V> entries;

    SegmentedEvictableDataContainer(BasicComponentRegistry registry, Configuration configuration) {
        super(PeekableTouchableContainerMap::new, configuration.clustering().hash().numSegments());
        ConcurrentHashMap futures = new ConcurrentHashMap();
        BiConsumer<Object, InternalCacheEntry> evictionListener = (key, entry) -> {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            futures.put(key, future);
            this.handleEviction((InternalCacheEntry<K, V>)entry, future);
        };
        BiConsumer<Object, InternalCacheEntry> removalListener = (key, entry) -> {
            CompletableFuture future = (CompletableFuture)futures.remove(key);
            if (future != null) {
                future.complete(null);
            }
        };
        org.wildfly.clustering.function.Supplier factory = DataContainerConfigurationBuilder::new;
        DataContainerConfiguration container = Optional.ofNullable((DataContainerConfiguration)configuration.module(DataContainerConfiguration.class)).orElseGet((Supplier<DataContainerConfiguration>)factory.thenApply(Builder::create));
        CacheConfiguration.Builder builder = CacheConfiguration.builder();
        if (configuration.memory().maxCount() > 0L) {
            builder.withMaxWeight(configuration.memory().maxCount()).evictableWhen(container.evictable());
        }
        Optional.ofNullable(container.idleTimeout()).ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).evictAfter(arg_0));
        Optional.ofNullable(registry.getComponent("org.infinispan.executors.expiration", ScheduledExecutorService.class)).map(ComponentRef::running).ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).withExecutor(arg_0));
        this.executor = (Executor)registry.getComponent("org.infinispan.executors.non-blocking", Executor.class).running();
        this.evictionCache = new CacheFactory().apply(builder.whenEvicted(evictionListener).whenRemoved(removalListener).build());
        this.entries = new PeekableTouchableCaffeineMap(this.evictionCache);
    }

    void handleEviction(InternalCacheEntry<K, V> entry, CompletableFuture<Void> future) {
        SegmentedEvictableDataContainer.handleEviction(entry, (DataOperationOrderer)this.orderer, (PassivationManager)((PassivationManager)this.passivator.running()), (EvictionManager)this.evictionManager, (DataContainer)this, (Executor)this.executor, future);
    }

    protected void computeEntryWritten(K key, InternalCacheEntry<K, V> value) {
        this.computeEntryWritten(this.getSegmentForKey(key), key, value);
    }

    void computeEntryWritten(int segment, K key, InternalCacheEntry<K, V> value) {
        PeekableTouchableMap map = super.getMapForSegment(segment);
        if (map != null) {
            map.put(key, value);
        }
    }

    protected void computeEntryRemoved(K key, InternalCacheEntry<K, V> value) {
        this.computeEntryRemoved(this.getSegmentForKey(key), key, value);
    }

    void computeEntryRemoved(int segment, K key, InternalCacheEntry<K, V> value) {
        PeekableTouchableMap map = super.getMapForSegment(segment);
        if (map != null) {
            map.remove(key, value);
        }
    }

    protected void putEntryInMap(PeekableTouchableMap<K, V> map, int segment, K key, InternalCacheEntry<K, V> entry) {
        map.compute(key, (k, v) -> {
            this.computeEntryWritten(segment, k, entry);
            return entry;
        });
    }

    protected InternalCacheEntry<K, V> removeEntryInMap(PeekableTouchableMap<K, V> map, int segment, Object key) {
        ByRef ref = new ByRef(null);
        map.computeIfPresent(key, (k, prev) -> {
            this.computeEntryRemoved(segment, (K)k, (InternalCacheEntry<K, V>)prev);
            ref.set(prev);
            return null;
        });
        return (InternalCacheEntry)ref.get();
    }

    public PeekableTouchableMap<K, V> getMapForSegment(int segment) {
        return this.entries;
    }

    public InternalCacheEntry<K, V> peek(Object k) {
        return this.peek(-1, k);
    }

    public void clear() {
        this.entries.clear();
        for (int i = 0; i < this.maps.length(); ++i) {
            this.clearMapIfPresent(i);
        }
    }

    public void clear(IntSet segments) {
        this.clear(segments, false);
        IntConsumer clearIfPresent = this::clearMapIfPresent;
        segments.forEach(clearIfPresent);
    }

    private void clearMapIfPresent(int segment) {
        ConcurrentMap map = (ConcurrentMap)this.maps.get(segment);
        if (map != null) {
            map.clear();
        }
    }

    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        ArrayList<Collection> valueIterables = new ArrayList<Collection>(segments.size() + 1);
        PrimitiveIterator.OfInt iter = segments.iterator();
        boolean includeOthers = false;
        while (iter.hasNext()) {
            int segment = iter.nextInt();
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segment);
            if (map != null) {
                valueIterables.add(map.values());
                continue;
            }
            includeOthers = true;
        }
        if (includeOthers) {
            valueIterables.add(this.entries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet()));
        }
        return new ConcatIterator(valueIterables);
    }

    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        int[] segmentArray = segments.toIntArray();
        AtomicBoolean usedOthers = new AtomicBoolean(false);
        return new FlattenSpliterator(i -> {
            Map map = (Map)this.maps.get(segmentArray[i]);
            if (map == null) {
                if (!usedOthers.getAndSet(true)) {
                    return this.entries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet());
                }
                return Collections.emptyList();
            }
            return map.values();
        }, segmentArray.length, 4353);
    }

    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    private void clear(IntSet segments, boolean keepSegments) {
        Iterator keyIterator = this.entries.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            int keySegment = this.getSegmentForKey(key);
            if (keepSegments == segments.contains(keySegment)) continue;
            keyIterator.remove();
        }
    }

    public void removeSegments(IntSet segments) {
        super.removeSegments(segments);
        this.clear(segments, false);
    }

    public long capacity() {
        return ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).getMaximum();
    }

    public void resize(long newSize) {
        ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).setMaximum(newSize);
    }

    public long evictionSize() {
        return ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).weightedSize().orElse(this.entries.size());
    }

    public void cleanUp() {
        this.evictionCache.cleanUp();
    }
}

