/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.BiPredicate;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.LongPredicate;

public interface Predicate<T>
extends java.util.function.Predicate<T> {
    public static final Predicate<?> ALWAYS = value -> true;
    public static final Predicate<?> NEVER = value -> false;

    default public Predicate<T> handle(final java.util.function.BiPredicate<T, RuntimeException> handler) {
        return new Predicate<T>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(T value) {
                try {
                    return this.this$0.test(value);
                }
                catch (RuntimeException e) {
                    return handler.test(value, e);
                }
            }
        };
    }

    default public <V> Predicate<V> compose(final Function<V, T> function) {
        return new Predicate<V>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(V test) {
                return this.this$0.test(function.apply(test));
            }
        };
    }

    default public <V1, V2> BiPredicate<V1, V2> composeBinary(final BiFunction<V1, V2, T> function) {
        return new BiPredicate<V1, V2>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(V1 test1, V2 test2) {
                return this.this$0.test(function.apply(test1, test2));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleFunction<T> function) {
        return new DoublePredicate(){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(function.apply(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntFunction<T> function) {
        return new IntPredicate(){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(function.apply(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongFunction<T> function) {
        return new LongPredicate(){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(function.apply(value));
            }
        };
    }

    @Override
    default public Predicate<T> negate() {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return !Predicate.this.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> and(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(T test) {
                return this.this$0.test(test) && other.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> or(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(T test) {
                return this.this$0.test(test) || other.test(test);
            }
        };
    }

    default public Predicate<T> xor(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(this){
            final /* synthetic */ Predicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(T test) {
                return this.this$0.test(test) ^ other.test(test);
            }
        };
    }

    public static <T> Predicate<T> of(boolean result) {
        return result ? Predicate.always() : Predicate.never();
    }

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    public static <T> Predicate<T> equalTo(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return Objects.equals(value, object);
            }
        };
    }

    public static <T> Predicate<T> identicalTo(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return object == value;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> lessThan(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return value.compareTo((Comparable)object) < 0;
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> greaterThan(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return value.compareTo((Comparable)object) > 0;
            }
        };
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return predicate.negate();
    }

    public static <K, V> Predicate<Map.Entry<K, V>> entry(final Predicate<K> key, final Predicate<V> value) {
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return key.test(entry.getKey()) && value.test(entry.getValue());
            }
        };
    }
}

