/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToIntFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.Predicate;

public interface IntPredicate
extends java.util.function.IntPredicate {
    public static final IntPredicate ALWAYS = value -> true;
    public static final IntPredicate NEVER = value -> false;
    public static final IntPredicate POSITIVE = IntPredicate.greaterThan(0);
    public static final IntPredicate ZERO = IntPredicate.equalTo(0);
    public static final IntPredicate NEGATIVE = IntPredicate.lessThan(0);

    default public <V> Predicate<V> compose(final ToIntFunction<V> composer) {
        return new Predicate<V>(this){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(V value) {
                return this.this$0.test(composer.applyAsInt(value));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleToIntFunction composer) {
        return new DoublePredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(composer.applyAsInt(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntUnaryOperator composer) {
        return new IntPredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(composer.applyAsInt(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongToIntFunction composer) {
        return new LongPredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(composer.applyAsInt(value));
            }
        };
    }

    @Override
    default public IntPredicate and(final java.util.function.IntPredicate other) {
        return new IntPredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public IntPredicate negate() {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return !IntPredicate.this.test(value);
            }
        };
    }

    @Override
    default public IntPredicate or(final java.util.function.IntPredicate other) {
        return new IntPredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(value) || other.test(value);
            }
        };
    }

    default public IntPredicate xor(final java.util.function.IntPredicate other) {
        return new IntPredicate(){
            final /* synthetic */ IntPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(value) ^ other.test(value);
            }
        };
    }

    public static IntPredicate of(boolean result) {
        return result ? ALWAYS : NEVER;
    }

    public static IntPredicate lessThan(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(value, base) < 0;
            }
        };
    }

    public static IntPredicate equalTo(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(base, value) == 0;
            }
        };
    }

    public static IntPredicate greaterThan(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(value, base) > 0;
            }
        };
    }
}

