/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.BinaryOperator;
import org.wildfly.clustering.function.Function;

public interface Consumer<T>
extends java.util.function.Consumer<T> {
    public static final Consumer<?> EMPTY = value -> {};
    public static final Map<System.Logger.Level, Consumer<Exception>> EXCEPTION_LOGGERS = EnumSet.allOf(System.Logger.Level.class).stream().collect(Collectors.toMap(Function.identity(), ExceptionLogger::new, BinaryOperator.former(), () -> new EnumMap(System.Logger.Level.class)));
    public static final Function<System.Logger.Level, Consumer<Exception>> EXCEPTION_LOGGER = EXCEPTION_LOGGERS::get;

    @Override
    default public Consumer<T> andThen(java.util.function.Consumer<? super T> after) {
        return Consumer.acceptAll(List.of(this, after));
    }

    default public Consumer<T> when(final Predicate<T> predicate) {
        return new Consumer<T>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(T value) {
                if (predicate.test(value)) {
                    this.this$0.accept(value);
                }
            }
        };
    }

    default public Consumer<T> withDefault(final Predicate<T> predicate, final Supplier<T> defaultValue) {
        return new Consumer<T>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(T value) {
                this.this$0.accept(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public <V> Consumer<V> compose(final java.util.function.Function<V, T> mapper) {
        return new Consumer<V>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V value) {
                this.this$0.accept(mapper.apply(value));
            }
        };
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final BiFunction<V1, V2, T> mapper) {
        return new BiConsumer<V1, V2>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V1 value1, V2 value2) {
                this.this$0.accept(mapper.apply(value1, value2));
            }
        };
    }

    default public Consumer<T> handle(final java.util.function.BiConsumer<T, RuntimeException> handler) {
        return new Consumer<T>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(T value) {
                try {
                    this.this$0.accept(value);
                }
                catch (RuntimeException e) {
                    handler.accept(value, e);
                }
            }
        };
    }

    default public <R> Function<T, R> thenReturn(final Supplier<R> factory) {
        return new Function<T, R>(this){
            final /* synthetic */ Consumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value) {
                this.this$0.accept(value);
                return factory.get();
            }
        };
    }

    public static <V> Consumer<V> empty() {
        return EMPTY;
    }

    public static <V extends AutoCloseable> Consumer<V> close() {
        return Consumer.close(Consumer.warning());
    }

    public static <E extends Exception> Consumer<E> log(System.Logger.Level level) {
        return (Consumer)EXCEPTION_LOGGER.apply(level);
    }

    public static <E extends Exception> Consumer<E> error() {
        return Consumer.log(System.Logger.Level.ERROR);
    }

    public static <E extends Exception> Consumer<E> warning() {
        return Consumer.log(System.Logger.Level.WARNING);
    }

    public static <E extends Exception> Consumer<E> info() {
        return Consumer.log(System.Logger.Level.INFO);
    }

    public static <E extends Exception> Consumer<E> debug() {
        return Consumer.log(System.Logger.Level.DEBUG);
    }

    public static <V extends AutoCloseable> Consumer<V> close(final java.util.function.Consumer<Exception> handler) {
        return new Consumer<V>(){

            @Override
            public void accept(AutoCloseable object) {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception e) {
                        handler.accept(e);
                    }
                }
            }
        };
    }

    public static <V> Consumer<V> run(final Runnable task) {
        return new Consumer<V>(){

            @Override
            public void accept(V ignored) {
                task.run();
            }
        };
    }

    public static <V> Consumer<V> acceptAll(final Iterable<? extends java.util.function.Consumer<? super V>> consumers) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                for (java.util.function.Consumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }

    public static <E extends Throwable> Consumer<E> throwing(final java.util.function.Function<E, ? extends RuntimeException> exceptionFactory) {
        return new Consumer<E>(){

            @Override
            public void accept(E exception) {
                throw (RuntimeException)exceptionFactory.apply(exception);
            }
        };
    }

    public static class ExceptionLogger<E extends Exception>
    implements Consumer<E> {
        private static final System.Logger LOGGER = System.getLogger(Consumer.class.getName());
        private final System.Logger.Level level;

        ExceptionLogger(System.Logger.Level level) {
            this.level = level;
        }

        @Override
        public void accept(E exception) {
            if (exception != null) {
                LOGGER.log(this.level, ((Throwable)exception).getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

