/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.AbstractModelResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.common.Assert;

class PatchResource
extends AbstractModelResource {
    private final ModelNode model = new ModelNode();

    protected PatchResource(ServiceController<InstallationManager> imController) {
        this(imController, true);
    }

    protected PatchResource(ServiceController<InstallationManager> imController, boolean includeStream) {
        super.registerResourceProvider("layer", (ResourceProvider)new LayerResourceProvider(imController));
        super.registerResourceProvider("addon", (ResourceProvider)new AddOnResourceProvider(imController));
        if (includeStream) {
            super.registerResourceProvider("patch-stream", (ResourceProvider)new PatchStreamResourceProvider(imController));
        }
        this.model.protect();
    }

    public ModelNode getModel() {
        return this.model;
    }

    public void writeModel(ModelNode newModel) {
        throw new UnsupportedOperationException();
    }

    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    public boolean isRuntime() {
        return true;
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public Resource clone() {
        return this;
    }

    class LayerResourceProvider
    extends ElementProviderResourceProvider {
        LayerResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
        }

        @Override
        protected Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity identity) {
            return identity.getLayers();
        }
    }

    class AddOnResourceProvider
    extends ElementProviderResourceProvider {
        AddOnResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
        }

        @Override
        protected Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity identity) {
            return identity.getAddOns();
        }
    }

    class PatchStreamResourceProvider
    extends PatchingChildResourceProvider {
        private final PatchResource child;

        PatchStreamResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
            this.child = new PatchResource(imController, false);
        }

        @Override
        public Resource get(String name) {
            return this.child;
        }

        public Set<String> children() {
            List<InstalledIdentity> installedIdentities;
            InstallationManager manager = this.getInstallationManager();
            if (manager == null) {
                return Collections.emptySet();
            }
            try {
                installedIdentities = manager.getInstalledIdentities();
            }
            catch (PatchingException e) {
                throw new IllegalStateException(e);
            }
            if (installedIdentities.size() == 1) {
                return Collections.singleton(installedIdentities.get(0).getIdentity().getName());
            }
            HashSet<String> set = new HashSet<String>(installedIdentities.size());
            for (InstalledIdentity identity : installedIdentities) {
                set.add(identity.getIdentity().getName());
            }
            return set;
        }
    }

    abstract class ElementProviderResourceProvider
    extends PatchingChildResourceProvider {
        ElementProviderResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
        }

        protected abstract Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity var1);

        public Set<String> children() {
            InstallationManager manager = this.getInstallationManager();
            if (manager == null) {
                return Collections.emptySet();
            }
            Collection<? extends PatchableTarget> targets = this.getChildTargets(manager.getDefaultIdentity());
            if (targets.isEmpty()) {
                return Collections.emptySet();
            }
            if (targets.size() == 1) {
                PatchableTarget target = targets.iterator().next();
                return Collections.singleton(target.getName());
            }
            HashSet<String> names = new HashSet<String>(targets.size());
            for (PatchableTarget patchableTarget : targets) {
                names.add(patchableTarget.getName());
            }
            return names;
        }
    }

    abstract class PatchingChildResourceProvider
    implements ResourceProvider {
        protected final ServiceController<InstallationManager> imController;

        PatchingChildResourceProvider(ServiceController<InstallationManager> imController) {
            this.imController = (ServiceController)Assert.checkNotNullParam((String)"imController", imController);
        }

        public boolean has(String name) {
            return this.children().contains(name);
        }

        public Resource get(String name) {
            return PlaceholderResource.INSTANCE;
        }

        public boolean hasChildren() {
            return !this.children().isEmpty();
        }

        public void register(String name, Resource resource) {
            throw new UnsupportedOperationException();
        }

        public void register(String value, int index, Resource resource) {
            throw new UnsupportedOperationException();
        }

        public Resource remove(String name) {
            throw new UnsupportedOperationException();
        }

        public ResourceProvider clone() {
            return this;
        }

        protected InstallationManager getInstallationManager() {
            while (this.imController != null && this.imController.getState() == ServiceController.State.UP) {
                try {
                    return (InstallationManager)this.imController.getValue();
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            return null;
        }
    }
}

