/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.context.ThreadContextClassLoaderReference;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;

public abstract class AbstractByteBufferMarshaller
implements ByteBufferMarshaller {
    private final Supplier<Context<ClassLoader>> contextProvider;

    protected AbstractByteBufferMarshaller(ClassLoader loader) {
        this.contextProvider = ThreadContextClassLoaderReference.CURRENT.provide((Object)loader);
    }

    @Override
    public Object read(ByteBuffer buffer) throws IOException {
        try (Context<ClassLoader> context = this.contextProvider.get();){
            Object object = ByteBufferMarshaller.super.read(buffer);
            return object;
        }
    }

    @Override
    public ByteBuffer write(Object object) throws IOException {
        try (Context<ClassLoader> context = this.contextProvider.get();){
            ByteBuffer byteBuffer = ByteBufferMarshaller.super.write(object);
            return byteBuffer;
        }
    }

    @Override
    public OptionalInt size(Object object) {
        final AtomicInteger size = new AtomicInteger();
        OutputStream output = new OutputStream(this){
            final /* synthetic */ AbstractByteBufferMarshaller this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(int b) throws IOException {
                size.setPlain(size.getPlain() + 1);
            }

            @Override
            public void write(byte[] bytes, int offset, int length) throws IOException {
                size.setPlain(size.getPlain() + length);
            }
        };
        try {
            this.writeTo(output, object);
            return OptionalInt.of(size.getPlain());
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }
}

