/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.impl;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private final AtomicInteger index = new AtomicInteger();

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No services found.");
        }
        ArrayList<ServiceInstance> modifiableList = new ArrayList<ServiceInstance>(serviceInstances);
        modifiableList.sort(Comparator.comparingLong(ServiceInstance::getId));
        return this.select(modifiableList);
    }

    public boolean requiresStrictRecording() {
        return false;
    }

    private ServiceInstance select(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            return null;
        }
        return instances.get(this.index.getAndIncrement() % instances.size());
    }
}

