/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrCleanHandler;
import org.wildfly.core.instmgr.InstMgrCreateSnapshotHandler;
import org.wildfly.core.instmgr.InstMgrCustomPatchRemoveHandler;
import org.wildfly.core.instmgr.InstMgrCustomPatchUploadHandler;
import org.wildfly.core.instmgr.InstMgrHistoryHandler;
import org.wildfly.core.instmgr.InstMgrHistoryRevisionHandler;
import org.wildfly.core.instmgr.InstMgrListUpdatesHandler;
import org.wildfly.core.instmgr.InstMgrPrepareRevertHandler;
import org.wildfly.core.instmgr.InstMgrPrepareUpdateHandler;
import org.wildfly.core.instmgr.InstMgrRemoveChannelHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

class InstMgrResourceDefinition
extends SimpleResourceDefinition {
    static final String PATH_MANAGER_CAP = "org.wildfly.management.path-manager";
    static final RuntimeCapability<Void> INSTALLATION_MANAGER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.core.installationmanager", InstMgrResourceDefinition.class).addRequirements(new String[]{"org.wildfly.management.path-manager"}).build();
    private final InstMgrService imService;
    private final InstallationManagerFactory imf;
    private static final AttributeDefinition REPOSITORY_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("id", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final AttributeDefinition REPOSITORY_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final ObjectTypeAttributeDefinition REPOSITORY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("repository", new AttributeDefinition[]{REPOSITORY_ID, REPOSITORY_URL}).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).setSuffix("repository").build();
    private static final AttributeDefinition REPOSITORIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("repositories", REPOSITORY).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final AttributeDefinition CHANNEL_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final AttributeDefinition MANIFEST_GAV = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("gav", ModelType.STRING).setAlternatives(new String[]{"url"})).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final AttributeDefinition MANIFEST_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING).setAlternatives(new String[]{"gav"})).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).build();
    private static final AttributeDefinition MANIFEST = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"manifest", (AttributeDefinition[])new AttributeDefinition[]{MANIFEST_GAV, MANIFEST_URL}).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).setSuffix("manifest").build();
    private static final ObjectTypeAttributeDefinition CHANNEL = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"channel", (AttributeDefinition[])new AttributeDefinition[]{CHANNEL_NAME, REPOSITORIES, MANIFEST}).setValidator((ParameterValidator)new ChannelValidator())).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(true)).setSuffix("channel").build();
    private static final AttributeDefinition CHANNELS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"channels", (ObjectTypeAttributeDefinition)CHANNEL).setStorageRuntime()).setRuntimeServiceNotRequired()).build();

    public static PathElement getPath(String name) {
        return PathElement.pathElement((String)"core-service", (String)name);
    }

    public InstMgrResourceDefinition(InstallationManagerFactory imf, InstMgrService imService) {
        super(new SimpleResourceDefinition.Parameters(InstMgrResourceDefinition.getPath("installer"), InstMgrResolver.RESOLVER).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.PATCHING}).setCapabilities(new RuntimeCapability[]{INSTALLATION_MANAGER_CAPABILITY}).setRuntime());
        this.imf = imf;
        this.imService = imService;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        InstMgrHistoryRevisionHandler historyRevisionHandler = new InstMgrHistoryRevisionHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrHistoryRevisionHandler.DEFINITION, (OperationStepHandler)historyRevisionHandler);
        InstMgrHistoryHandler historyHandler = new InstMgrHistoryHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrHistoryHandler.DEFINITION, (OperationStepHandler)historyHandler);
        InstMgrCreateSnapshotHandler createSnapshotHandler = new InstMgrCreateSnapshotHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrCreateSnapshotHandler.DEFINITION, (OperationStepHandler)createSnapshotHandler);
        InstMgrListUpdatesHandler lstUpdatesHandler = new InstMgrListUpdatesHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrListUpdatesHandler.DEFINITION, (OperationStepHandler)lstUpdatesHandler);
        InstMgrCleanHandler clean = new InstMgrCleanHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrCleanHandler.DEFINITION, (OperationStepHandler)clean);
        InstMgrPrepareUpdateHandler prepUpdatesHandler = new InstMgrPrepareUpdateHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrPrepareUpdateHandler.DEFINITION, (OperationStepHandler)prepUpdatesHandler);
        InstMgrPrepareRevertHandler revertHandler = new InstMgrPrepareRevertHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrPrepareRevertHandler.DEFINITION, (OperationStepHandler)revertHandler);
        InstMgrRemoveChannelHandler channelRemoveHandler = new InstMgrRemoveChannelHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrRemoveChannelHandler.DEFINITION, (OperationStepHandler)channelRemoveHandler);
        InstMgrCustomPatchUploadHandler customPatchUploadHandler = new InstMgrCustomPatchUploadHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrCustomPatchUploadHandler.DEFINITION, (OperationStepHandler)customPatchUploadHandler);
        InstMgrCustomPatchRemoveHandler customPatchRemoveHandler = new InstMgrCustomPatchRemoveHandler(this.imService, this.imf);
        resourceRegistration.registerOperationHandler(InstMgrCustomPatchRemoveHandler.DEFINITION, (OperationStepHandler)customPatchRemoveHandler);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute(CHANNELS, (OperationStepHandler)new ReadHandler(), (OperationStepHandler)new WriteHandler());
    }

    private class ReadHandler
    implements OperationStepHandler {
        private ReadHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    try {
                        ModelNode result = context.getResult();
                        Path serverHome = InstMgrResourceDefinition.this.imService.getHomeDir();
                        MavenOptions mavenOptions = new MavenOptions(null, false);
                        InstallationManager installationManager = InstMgrResourceDefinition.this.imf.create(serverHome, mavenOptions);
                        ModelNode mChannels = new ModelNode().addEmptyList();
                        Collection channels = installationManager.listChannels();
                        for (Channel channel : channels) {
                            ModelNode mChannel = new ModelNode();
                            mChannel.get("name").set(channel.getName());
                            ModelNode mRepositories = new ModelNode().addEmptyList();
                            for (Repository repository : channel.getRepositories()) {
                                ModelNode mRepository = new ModelNode();
                                mRepository.get("id").set(repository.getId());
                                mRepository.get("url").set(repository.getUrl());
                                mRepositories.add(mRepository);
                            }
                            mChannel.get("repositories").set(mRepositories);
                            ModelNode mManifest = new ModelNode();
                            if (channel.getManifestCoordinate().isPresent()) {
                                mManifest.get("gav").set((String)channel.getManifestCoordinate().get());
                                mChannel.get("manifest").set(mManifest);
                            } else if (channel.getManifestUrl().isPresent()) {
                                mManifest.get("url").set(((URL)channel.getManifestUrl().get()).toExternalForm());
                                mChannel.get("manifest").set(mManifest);
                            }
                            mChannels.add(mChannel);
                        }
                        result.set(mChannels);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private class WriteHandler
    implements OperationStepHandler {
        private WriteHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList channelsListMn = new ArrayList();
            if (operation.hasDefined("value")) {
                channelsListMn.addAll(CHANNELS.resolveValue(context, operation.get("value")).asList());
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.acquireControllerLock();
                    try {
                        Path serverHome = InstMgrResourceDefinition.this.imService.getHomeDir();
                        MavenOptions mavenOptions = new MavenOptions(null, false);
                        InstallationManager installationManager = InstMgrResourceDefinition.this.imf.create(serverHome, mavenOptions);
                        Collection exitingChannels = installationManager.listChannels();
                        HashSet<String> exitingChannelNames = new HashSet<String>();
                        for (Channel c : exitingChannels) {
                            exitingChannelNames.add(c.getName());
                        }
                        if (channelsListMn.isEmpty()) {
                            for (Channel c : exitingChannels) {
                                installationManager.removeChannel(c.getName());
                            }
                        } else {
                            for (ModelNode mChannel : channelsListMn) {
                                Channel c;
                                String cName = mChannel.get("name").asString();
                                ArrayList<Repository> repositories = new ArrayList<Repository>();
                                List mRepositories = mChannel.get("repositories").asListOrEmpty();
                                for (ModelNode mRepository : mRepositories) {
                                    String id = mRepository.get("id").asString();
                                    String url = mRepository.get("url").asString();
                                    Repository repository = new Repository(id, new URI(url).toURL().toExternalForm());
                                    repositories.add(repository);
                                }
                                if (mChannel.hasDefined("manifest")) {
                                    ModelNode mManifest = mChannel.get("manifest");
                                    if (mManifest.hasDefined("gav")) {
                                        String manifestGav = mManifest.get("gav").asString();
                                        c = new Channel(cName, repositories, manifestGav);
                                    } else {
                                        URL manifestUrl = new URI(mManifest.get("url").asString()).toURL();
                                        c = new Channel(cName, repositories, manifestUrl);
                                    }
                                } else {
                                    c = new Channel(cName, repositories);
                                }
                                if (exitingChannelNames.contains(c.getName())) {
                                    installationManager.changeChannel(c);
                                    continue;
                                }
                                installationManager.addChannel(c);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class ChannelValidator
    extends ObjectTypeValidator {
        public ChannelValidator() {
            super(true, new AttributeDefinition[]{CHANNEL_NAME, REPOSITORIES, MANIFEST});
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (!value.hasDefined("name")) {
                throw InstMgrLogger.ROOT_LOGGER.missingChannelName();
            }
            String channelName = value.get("name").asString();
            if (!value.hasDefined("repositories")) {
                throw InstMgrLogger.ROOT_LOGGER.noChannelRepositoriesDefined(channelName);
            }
            List repositoriesMn = value.get("repositories").asListOrEmpty();
            for (ModelNode repository : repositoriesMn) {
                String repoUrl = repository.get("url").asStringOrNull();
                if (repoUrl == null) {
                    throw InstMgrLogger.ROOT_LOGGER.noChannelRepositoryURLDefined(channelName);
                }
                try {
                    new URI(repoUrl).toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw InstMgrLogger.ROOT_LOGGER.invalidChannelRepositoryURL(repoUrl, channelName);
                }
                String repoId = repository.get("id").asStringOrNull();
                if (repoId != null) continue;
                throw InstMgrLogger.ROOT_LOGGER.noChannelRepositoryIDDefined(channelName);
            }
            if (value.hasDefined("manifest")) {
                String gav = value.get("manifest").get("gav").asStringOrNull();
                String url = value.get("manifest").get("url").asStringOrNull();
                if (gav != null) {
                    String[] parts;
                    if (gav.contains("\\") || gav.contains("/")) {
                        throw InstMgrLogger.ROOT_LOGGER.invalidChannelManifestGAV(gav, channelName);
                    }
                    for (String part : parts = gav.split(":")) {
                        if (part != null && !"".equals(part)) continue;
                        throw InstMgrLogger.ROOT_LOGGER.invalidChannelManifestGAV(gav, channelName);
                    }
                    if (parts.length != 2 && parts.length != 3) {
                        throw InstMgrLogger.ROOT_LOGGER.invalidChannelManifestGAV(gav, channelName);
                    }
                }
                if (url != null) {
                    try {
                        new URI(url).toURL();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        throw InstMgrLogger.ROOT_LOGGER.invalidChannelManifestURL(url, channelName);
                    }
                }
            }
        }
    }
}

