/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.listener;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;

public interface ConsumerRegistry<T>
extends Registrar<Consumer<T>>,
Consumer<T> {
    public static <T> ConsumerRegistry<T> newInstance() {
        return ConsumerRegistry.newInstance(CopyOnWriteArrayList::new);
    }

    public static <T> ConsumerRegistry<T> newInstance(Supplier<Collection<Consumer<T>>> factory) {
        final Collection consumers = (Collection)factory.get();
        final System.Logger logger = System.getLogger(ConsumerRegistry.class.getName());
        return new ConsumerRegistry<T>(){

            public Registration register(Consumer<T> consumer) {
                consumers.add(consumer);
                return () -> consumers.remove(consumer);
            }

            @Override
            public void accept(T value) {
                for (Consumer consumer : consumers) {
                    try {
                        consumer.accept(value);
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
            }
        };
    }
}

