/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.immutable;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import org.wildfly.clustering.server.immutable.DefaultImmutability;
import org.wildfly.clustering.server.immutable.UnmodifiableImmutability;

public interface Immutability
extends Predicate<Object> {
    default public Immutability and(final Predicate<? super Object> immutability) {
        return new Immutability(){
            final /* synthetic */ Immutability this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(Object object) {
                return this.this$0.test(object) && immutability.test(object);
            }
        };
    }

    default public Immutability negate() {
        return new Immutability(){

            @Override
            public boolean test(Object object) {
                return !Immutability.this.test(object);
            }
        };
    }

    default public Immutability or(final Predicate<? super Object> immutability) {
        return new Immutability(){
            final /* synthetic */ Immutability this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(Object object) {
                return this.this$0.test(object) || immutability.test(object);
            }
        };
    }

    public static Immutability getDefault() {
        return Immutability.composite(EnumSet.allOf(DefaultImmutability.class));
    }

    public static Immutability composite(final Collection<? extends Immutability> immutabilities) {
        return new Immutability(){
            private Immutability unmodifiable = new UnmodifiableImmutability(this);

            @Override
            public boolean test(Object object) {
                if (object == null) {
                    return true;
                }
                if (object.getClass().isArray()) {
                    return Array.getLength(object) == 0;
                }
                for (Immutability immutability : immutabilities) {
                    if (!immutability.test(object)) continue;
                    return true;
                }
                return this.unmodifiable.test(object);
            }
        };
    }

    public static Immutability classes(Collection<Class<?>> immutableClasses) {
        final Set<Class<?>> classes = UnmodifiableImmutability.identitySet(immutableClasses);
        return new Immutability(){

            @Override
            public boolean test(Object object) {
                return object == null || classes.contains(object.getClass());
            }
        };
    }

    public static Immutability identity(Collection<Object> immutableObjects) {
        final Set<Object> objects = UnmodifiableImmutability.identitySet(immutableObjects);
        return new Immutability(){

            @Override
            public boolean test(Object object) {
                return object == null || objects.contains(object);
            }
        };
    }

    public static Immutability instanceOf(final Collection<Class<?>> immutableClasses) {
        return new Immutability(){

            @Override
            public boolean test(Object object) {
                if (object == null) {
                    return true;
                }
                for (Class immutableClass : immutableClasses) {
                    if (!immutableClass.isInstance(object)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

