/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.UndertowOptions;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.PredicateValidator;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.AbstractFilterDefinition;
import org.wildfly.extension.undertow.filters.FailoverStrategy;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterServiceConfigurator;
import org.wildfly.extension.undertow.filters.ModClusterServiceNameProvider;
import org.wildfly.extension.undertow.filters.NoAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.PredicateHandlerWrapper;
import org.wildfly.extension.undertow.filters.RankedAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.SingleAffinityResourceDefinition;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;
import org.xnio.Option;

public class ModClusterDefinition
extends AbstractFilterDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"mod-cluster");
    public static final AttributeDefinition MANAGEMENT_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-socket-binding", ModelType.STRING).setAllowExpression(true)).setRequired(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(Capability.MOD_CLUSTER_FILTER_CAPABILITY.getDefinition(), (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build())).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-socket-binding", ModelType.STRING).setAllowExpression(true)).setRequired(false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(Capability.MOD_CLUSTER_FILTER_CAPABILITY.getDefinition(), (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build())).setRestartAllServices()).build();
    public static final AttributeDefinition SECURITY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-key", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-protocol", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("http"))).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-path", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("/"))).setRestartAllServices()).build();
    public static final AttributeDefinition ADVERTISE_FREQUENCY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("advertise-frequency", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(10000))).setRestartAllServices()).build();
    public static final AttributeDefinition FAILOVER_STRATEGY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("failover-strategy", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)EnumValidator.create(FailoverStrategy.class))).setRestartAllServices()).setDefaultValue(new ModelNode(FailoverStrategy.LOAD_BALANCED.name()))).build();
    public static final AttributeDefinition HEALTH_CHECK_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("health-check-interval", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(10000))).setRestartAllServices()).build();
    public static final AttributeDefinition BROKEN_NODE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("broken-node-timeout", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(60000))).setRestartAllServices()).build();
    public static final AttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.io.worker")).setRestartAllServices()).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setDefaultValue(new ModelNode(-1))).setRestartAllServices()).build();
    public static final AttributeDefinition MANAGEMENT_ACCESS_PREDICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-access-predicate", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)PredicateValidator.INSTANCE)).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).setRestartAllServices()).build();
    public static final AttributeDefinition CACHED_CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cached-connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).setRestartAllServices()).build();
    public static final AttributeDefinition CONNECTION_IDLE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-idle-timeout", ModelType.INT).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(60))).setRestartAllServices()).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1000))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAlternatives(new String[]{"security-realm"})).setCapabilityReference("org.wildfly.security.ssl-context")).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAlternatives(new String[]{"ssl-context"})).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).setDeprecated(ModelVersion.create((int)4, (int)0, (int)0))).build();
    public static final SimpleAttributeDefinition USE_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-alias", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ENABLE_HTTP2 = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-http2", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_AJP_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-ajp-packet-size", ModelType.INT).setRequired(false)).setRestartAllServices()).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowExpression(true)).setDefaultValue(new ModelNode(8192))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_ENABLE_PUSH = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-enable-push", (Option)UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    public static final OptionAttributeDefinition HTTP2_HEADER_TABLE_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-header-table-size", (Option)UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(4096))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_INITIAL_WINDOW_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-initial-window-size", (Option)UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(65535))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_CONCURRENT_STREAMS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-concurrent-streams", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_FRAME_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-frame-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(16384))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final OptionAttributeDefinition HTTP2_MAX_HEADER_LIST_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-header-list-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final AttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-retries", ModelType.INT).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode(1L))).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(MANAGEMENT_SOCKET_BINDING, ADVERTISE_SOCKET_BINDING, SECURITY_KEY, ADVERTISE_PROTOCOL, ADVERTISE_PATH, ADVERTISE_FREQUENCY, FAILOVER_STRATEGY, HEALTH_CHECK_INTERVAL, BROKEN_NODE_TIMEOUT, WORKER, MAX_REQUEST_TIME, MANAGEMENT_ACCESS_PREDICATE, CONNECTIONS_PER_THREAD, CACHED_CONNECTIONS_PER_THREAD, CONNECTION_IDLE_TIMEOUT, REQUEST_QUEUE_SIZE, SECURITY_REALM, SSL_CONTEXT, USE_ALIAS, ENABLE_HTTP2, MAX_AJP_PACKET_SIZE, HTTP2_MAX_HEADER_LIST_SIZE, HTTP2_MAX_FRAME_SIZE, HTTP2_MAX_CONCURRENT_STREAMS, HTTP2_INITIAL_WINDOW_SIZE, HTTP2_HEADER_TABLE_SIZE, HTTP2_ENABLE_PUSH, MAX_RETRIES);
    private final ServiceValueExecutorRegistry<ModCluster> registry = ServiceValueExecutorRegistry.newInstance();

    ModClusterDefinition() {
        super(PATH_ELEMENT);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(ATTRIBUTES).addCapabilities(Capability.class).addRequiredSingletonChildren(new PathElement[]{SingleAffinityResourceDefinition.PATH}).setResourceTransformation(ModClusterResource::new);
        ModClusterResourceServiceHandler handler = new ModClusterResourceServiceHandler((ServiceValueRegistry<ModCluster>)this.registry);
        new SimpleResourceRegistrar(descriptor, (ResourceServiceHandler)handler).register(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        new NoAffinityResourceDefinition().register(resourceRegistration);
        new SingleAffinityResourceDefinition().register(resourceRegistration);
        new RankedAffinityResourceDefinition().register(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new ModClusterBalancerDefinition((FunctionExecutorRegistry<ModCluster>)this.registry));
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        MOD_CLUSTER_FILTER_CAPABILITY("org.wildfly.undertow.mod_cluster-filter", HandlerWrapper.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> serviceValueType) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true, serviceValueType).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.DEFAULT).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }
    }

    static class ModClusterResourceServiceHandler
    implements ResourceServiceHandler {
        private final ServiceValueRegistry<ModCluster> registry;
        private final Map<PathAddress, Consumer<OperationContext>> removers = new ConcurrentHashMap<PathAddress, Consumer<OperationContext>>();

        ModClusterResourceServiceHandler(ServiceValueRegistry<ModCluster> registry) {
            this.registry = registry;
        }

        public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            String managementAccessPredicateString = MANAGEMENT_ACCESS_PREDICATE.resolveModelAttribute(context, model).asStringOrNull();
            final Predicate managementAccessPredicate = managementAccessPredicateString != null ? PredicateParser.parse((String)managementAccessPredicateString, (ClassLoader)this.getClass().getClassLoader()) : null;
            ModClusterServiceConfigurator configurator = new ModClusterServiceConfigurator(address);
            configurator.configure(context, model).build(context.getServiceTarget()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            this.removers.put(address, this.registry.capture(ServiceDependency.on((ServiceName)configurator.getServiceName())).install(context));
            RuntimeCapability<Void> capability = Capability.MOD_CLUSTER_FILTER_CAPABILITY.getDefinition();
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(capability);
            Consumer filter = builder.provides(capability, UndertowService.FILTER.append(new String[]{context.getCurrentAddressValue()}), new ServiceName[0]);
            final Supplier serviceRequirement = builder.requires(configurator.getServiceName());
            final Supplier configRequirement = builder.requires(configurator.getConfigServiceName());
            PredicateHandlerWrapper wrapper = PredicateHandlerWrapper.filter(new HandlerWrapper(){

                public HttpHandler wrap(final HttpHandler next) {
                    ModCluster modCluster = (ModCluster)serviceRequirement.get();
                    MCMPConfig config = (MCMPConfig)configRequirement.get();
                    final HttpHandler proxyHandler = modCluster.createProxyHandler(next);
                    HttpHandler realNext = new HttpHandler(){

                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            proxyHandler.handleRequest(exchange);
                            if (!exchange.isDispatched() && !exchange.isComplete()) {
                                exchange.setStatusCode(200);
                                next.handleRequest(exchange);
                            }
                        }
                    };
                    HttpHandler mcmpHandler = config.create(modCluster, realNext);
                    return managementAccessPredicate != null ? Handlers.predicate((Predicate)managementAccessPredicate, (HttpHandler)mcmpHandler, (HttpHandler)next) : mcmpHandler;
                }
            });
            builder.setInstance(Service.newInstance((Consumer)filter, (Object)wrapper)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }

        public void removeServices(OperationContext context, ModelNode model) {
            PathAddress address = context.getCurrentAddress();
            context.removeService(new ModClusterServiceNameProvider(address).getServiceName());
            context.removeService(Capability.MOD_CLUSTER_FILTER_CAPABILITY.getDefinition().getCapabilityServiceName(address));
            Consumer<OperationContext> remover = this.removers.remove(address);
            if (remover != null) {
                remover.accept(context);
            }
        }
    }
}

