/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.util.Collections;
import java.util.List;

public class AmqpAttributesExtractor
implements AttributesExtractor<AmqpMessage<?>, Void> {
    private final MessagingAttributesGetter<AmqpMessage<?>, Void> messagingAttributesGetter = new AmqpMessagingAttributesGetter();

    public MessagingAttributesGetter<AmqpMessage<?>, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, AmqpMessage<?> amqpMessage) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, AmqpMessage<?> amqpMessage, Void unused, Throwable error) {
    }

    private static class AmqpMessagingAttributesGetter
    implements MessagingAttributesGetter<AmqpMessage<?>, Void> {
        private AmqpMessagingAttributesGetter() {
        }

        public String getSystem(AmqpMessage<?> amqpMessage) {
            return "AMQP 1.0";
        }

        public String getDestination(AmqpMessage<?> amqpMessage) {
            return amqpMessage.getAddress();
        }

        public boolean isTemporaryDestination(AmqpMessage<?> amqpMessage) {
            return false;
        }

        public String getConversationId(AmqpMessage<?> amqpMessage) {
            Object correlationId = amqpMessage.getCorrelationId();
            return correlationId instanceof String ? (String)correlationId : null;
        }

        public String getMessageId(AmqpMessage<?> amqpMessage, Void unused) {
            Object messageId = amqpMessage.getMessageId();
            return messageId instanceof String ? (String)messageId : null;
        }

        public List<String> getMessageHeader(AmqpMessage<?> amqpMessage, String name) {
            return Collections.emptyList();
        }

        public String getDestinationTemplate(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public boolean isAnonymousDestination(AmqpMessage<?> amqpMessage) {
            return false;
        }

        public Long getMessageBodySize(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public Long getMessageEnvelopeSize(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public String getClientId(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public Long getBatchMessageCount(AmqpMessage<?> amqpMessage, Void unused) {
            return null;
        }
    }
}

