/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.staticlist;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.utils.HostAndPort;
import io.smallrye.stork.utils.InMemoryAddressesBackend;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.StorkAddressUtils;
import java.util.ArrayList;
import java.util.List;

public final class StaticListServiceDiscovery
implements ServiceDiscovery {
    private final List<ServiceInstance> instances;
    private final String serviceName;

    public StaticListServiceDiscovery(String serviceName, List<DefaultServiceInstance> instances) {
        this.serviceName = serviceName;
        this.instances = new ArrayList<DefaultServiceInstance>(instances);
    }

    public Uni<List<ServiceInstance>> getServiceInstances() {
        List addresses = InMemoryAddressesBackend.getAddresses((String)this.serviceName);
        if (addresses != null && !addresses.isEmpty()) {
            for (String address : addresses) {
                try {
                    HostAndPort hostAndPort = StorkAddressUtils.parseToHostAndPort((String)address, (int)80, (String)"service");
                    DefaultServiceInstance serviceInstance = new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), hostAndPort.host, hostAndPort.port, hostAndPort.path, false);
                    if (this.instances.contains(serviceInstance)) continue;
                    this.instances.add((ServiceInstance)serviceInstance);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Address not parseable to URL: " + address + " for service " + this.serviceName);
                }
            }
        }
        return Uni.createFrom().item(this.instances);
    }
}

