/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.iteration.RemotePublisher;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.reactive.AbstractAsyncPublisherHandler;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.logging.TraceException;

class RemoteInnerPublisherHandler<K, E>
extends AbstractAsyncPublisherHandler<Map.Entry<SocketAddress, IntSet>, Map.Entry<K, E>, IterationStartResponse, IterationNextResponse<K, E>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected final RemotePublisher<K, E> publisher;
    protected volatile SocketAddress socketAddress;
    private volatile byte[] iterationId;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    protected RemoteInnerPublisherHandler(RemotePublisher<K, E> parent, int batchSize, Supplier<Map.Entry<SocketAddress, IntSet>> supplier, Map.Entry<SocketAddress, IntSet> firstTarget) {
        super(batchSize, supplier, firstTarget);
        this.publisher = parent;
    }

    private String iterationId() {
        return this.publisher.iterationId(this.iterationId);
    }

    protected void sendCancel(Map.Entry<SocketAddress, IntSet> target) {
        if (!this.cancelled.getAndSet(true)) {
            this.actualCancel();
        }
    }

    private void actualCancel() {
        if (this.iterationId != null && this.socketAddress != null) {
            this.publisher.sendCancel(this.iterationId, this.socketAddress);
        }
    }

    protected CompletionStage<IterationStartResponse> sendInitialCommand(Map.Entry<SocketAddress, IntSet> target, int batchSize) {
        SocketAddress address = target.getKey();
        IntSet segments = target.getValue();
        log.tracef("Starting iteration with segments %s", segments);
        return this.publisher.newIteratorStartOperation(address, segments, batchSize);
    }

    protected CompletionStage<IterationNextResponse<K, E>> sendNextCommand(Map.Entry<SocketAddress, IntSet> target, int batchSize) {
        return this.publisher.newIteratorNextOperation(this.iterationId, this.socketAddress);
    }

    protected long handleInitialResponse(IterationStartResponse startResponse, Map.Entry<SocketAddress, IntSet> target) {
        this.socketAddress = startResponse.getSocketAddress();
        this.iterationId = startResponse.getIterationId();
        if (log.isDebugEnabled()) {
            log.iterationTransportObtained(this.socketAddress, this.iterationId());
            log.startedIteration(this.iterationId());
        }
        if (this.cancelled.get()) {
            this.actualCancel();
        }
        return 0L;
    }

    protected long handleNextResponse(IterationNextResponse<K, E> nextResponse, Map.Entry<SocketAddress, IntSet> target) {
        IntSet completedSegments;
        if (!nextResponse.hasMore()) {
            this.sendCancel(target);
            if (nextResponse.getStatus() != 5) {
                log.tracef("No more entries retrieved, so completing segments %s from %s", target.getValue(), target.getKey());
                this.publisher.completeSegments(target.getValue());
            } else {
                log.tracef("Invalid iteration response, so must retry segments %s", target.getValue());
            }
            this.targetComplete();
        }
        if ((completedSegments = nextResponse.getCompletedSegments()) != null && log.isTraceEnabled()) {
            IntSet targetSegments = target.getValue();
            if (targetSegments != null) {
                targetSegments.removeAll(completedSegments);
            }
            log.tracef("Completed segments: %s still have %s left for %s", completedSegments, targetSegments, target.getKey());
        }
        this.publisher.completeSegments(completedSegments);
        List<Map.Entry<K, E>> entries = nextResponse.getEntries();
        for (Map.Entry<K, E> entry : entries) {
            if (!this.onNext(entry)) break;
        }
        return entries.size();
    }

    protected void handleThrowableInResponse(Throwable t, Map.Entry<SocketAddress, IntSet> target) {
        if ((t instanceof TransportException || t instanceof RemoteIllegalLifecycleStateException || t instanceof ConnectException) && target.getKey() != null) {
            IntSet targetSegments;
            log.throwableDuringPublisher(t);
            if (log.isTraceEnabled() && (targetSegments = target.getValue()) != null) {
                log.tracef("There are still outstanding segments %s that will need to be retried", targetSegments);
            }
            this.publisher.erroredServer(target.getKey());
            this.targetComplete();
            this.accept(0L);
        } else {
            t.addSuppressed((Throwable)new TraceException());
            super.handleThrowableInResponse(t, target);
        }
    }
}

