/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.counter.operation.AddListenerOperation;
import org.infinispan.client.hotrod.counter.operation.RemoveListenerOperation;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.event.impl.CounterEventDispatcher;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.commons.util.concurrent.NonReentrantLock;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;

public class NotificationManager {
    private static final Log log = LogFactory.getLog(NotificationManager.class, Log.class);
    private static final CompletableFuture<Short> NO_ERROR_FUTURE = CompletableFuture.completedFuture((short)0);
    private final byte[] listenerId;
    private final ClientListenerNotifier notifier;
    private final CounterOperationFactory factory;
    private final OperationDispatcher operationDispatcher;
    private final ConcurrentMap<String, List<Consumer<HotRodCounterEvent>>> clientListeners = new ConcurrentHashMap<String, List<Consumer<HotRodCounterEvent>>>();
    private final Lock lock = new NonReentrantLock();
    private volatile CounterEventDispatcher dispatcher;

    NotificationManager(ClientListenerNotifier notifier, CounterOperationFactory factory, OperationDispatcher operationDispatcher) {
        this.notifier = notifier;
        this.factory = factory;
        this.operationDispatcher = operationDispatcher;
        this.listenerId = new byte[16];
        ThreadLocalRandom.current().nextBytes(this.listenerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CounterListener> Handle<T> addListener(String counterName, T listener) {
        CounterEventDispatcher dispatcher;
        if (log.isTraceEnabled()) {
            log.tracef("Add listener for counter '%s'", counterName);
        }
        if ((dispatcher = this.dispatcher) != null) {
            return this.registerListener(counterName, listener, dispatcher.address());
        }
        log.debugf("ALock %s", this.lock);
        this.lock.lock();
        try {
            dispatcher = this.dispatcher;
            Handle<T> handle = this.registerListener(counterName, listener, dispatcher == null ? null : dispatcher.address());
            return handle;
        }
        finally {
            this.lock.unlock();
            log.debugf("AUnLock %s", this.lock);
        }
    }

    private <T extends CounterListener> Handle<T> registerListener(String counterName, T listener, SocketAddress address) {
        HandleImpl handle = new HandleImpl(this, counterName, listener);
        this.clientListeners.computeIfAbsent(counterName, name -> {
            AddListenerOperation op = this.factory.newAddListenerOperation(counterName, this.listenerId);
            if (address == null) {
                Channel channel = Util.await(this.operationDispatcher.execute(op));
                ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).addListener(this.listenerId);
                this.dispatcher = new CounterEventDispatcher(this.listenerId, this.clientListeners, ChannelRecord.of(channel), this::failover, () -> channel.eventLoop().execute(() -> {
                    HeaderDecoder decoder;
                    if (log.isTraceEnabled()) {
                        log.tracef("Cleanup for %s on %s", this, channel);
                    }
                    if ((decoder = (HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)) != null) {
                        decoder.removeListener(this.listenerId);
                    }
                }));
            } else {
                Util.await(this.operationDispatcher.executeOnSingleAddress(op, address));
            }
            this.notifier.addDispatcher(this.dispatcher);
            this.notifier.startClientListener(this.listenerId);
            return new CopyOnWriteArrayList();
        }).add(handle);
        return handle;
    }

    private void removeListener(String counterName, HandleImpl<?> handle) {
        if (log.isTraceEnabled()) {
            log.tracef("Remove listener for counter '%s'", counterName);
        }
        this.clientListeners.computeIfPresent(counterName, (name, list) -> {
            list.remove(handle);
            if (list.isEmpty()) {
                RemoveListenerOperation op;
                if (this.dispatcher != null && !Util.await(this.operationDispatcher.executeOnSingleAddress(op = this.factory.newRemoveListenerOperation(counterName, this.listenerId), this.dispatcher.address())).booleanValue()) {
                    log.debugf("Failed to remove counter listener %s on server side", counterName);
                }
                return null;
            }
            return list;
        });
    }

    private CompletableFuture<Void> failover() {
        this.dispatcher = null;
        Iterator iterator = this.clientListeners.keySet().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String firstCounterName = (String)iterator.next();
        AddListenerOperation op = this.factory.newAddListenerOperation(firstCounterName, this.listenerId);
        log.debugf("Lock %s", this.lock);
        this.lock.lock();
        if (this.dispatcher == null) {
            this.operationDispatcher.execute(op).whenComplete((channel, throwable) -> {
                if (throwable != null) {
                    this.lock.unlock();
                    log.debugf((Throwable)throwable, "Failed to failover counter listener %s", firstCounterName);
                    cf.completeExceptionally((Throwable)throwable);
                } else {
                    SocketAddress address;
                    AtomicInteger counter = new AtomicInteger(1);
                    try {
                        if (channel != null) {
                            log.debugf("Creating new counter event dispatcher on %s", channel);
                            this.dispatcher = new CounterEventDispatcher(this.listenerId, this.clientListeners, channel.remoteAddress(), this::failover, null);
                            this.notifier.addDispatcher(this.dispatcher);
                            this.notifier.startClientListener(this.listenerId);
                        }
                        address = this.dispatcher.address();
                    }
                    catch (Throwable t) {
                        cf.completeExceptionally(t);
                        return;
                    }
                    finally {
                        this.lock.unlock();
                        log.debugf("UnLock %s", this.lock);
                    }
                    while (iterator.hasNext()) {
                        String counterName = (String)iterator.next();
                        this.operationDispatcher.executeOnSingleAddress(this.factory.newAddListenerOperation(counterName, this.listenerId), address).whenComplete((___, throwable2) -> {
                            if (throwable2 != null) {
                                log.debugf((Throwable)throwable2, "Failed to failover counter listener %s", counterName);
                                cf.completeExceptionally((Throwable)throwable2);
                            } else if (counter.decrementAndGet() == 0) {
                                cf.complete(null);
                            }
                        });
                    }
                    if (counter.decrementAndGet() == 0) {
                        cf.complete(null);
                    }
                }
            });
            return cf;
        }
        this.lock.unlock();
        log.debugf("UnLock %s", this.lock);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.debugf("Stopping %s (%s)", this, this.lock);
        this.lock.lock();
        try {
            AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (String counterName : this.clientListeners.keySet()) {
                RemoveListenerOperation op = this.factory.newRemoveListenerOperation(counterName, this.listenerId);
                aggregateCompletionStage.dependsOn(this.operationDispatcher.executeOnSingleAddress(op, this.dispatcher.address()));
            }
            Util.await(aggregateCompletionStage.freeze());
            this.clientListeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class HandleImpl<T extends CounterListener>
    implements Handle<T>,
    Consumer<HotRodCounterEvent> {
        private final T listener;
        private final String counterName;
        final /* synthetic */ NotificationManager this$0;

        private HandleImpl(String counterName, T listener) {
            this.this$0 = var1_1;
            this.counterName = counterName;
            this.listener = listener;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.this$0.removeListener(this.counterName, this);
        }

        @Override
        public void accept(HotRodCounterEvent event) {
            try {
                this.listener.onUpdate((CounterEvent)event);
            }
            catch (Throwable t) {
                log.debug("Exception in user listener", t);
            }
        }
    }
}

