/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class RegexAttributeDefinitions {
    static final SimpleAttributeDefinition PATTERN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new RegExValidator())).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PATTERN_CAPTURE_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new CaptureGroupRexExValidator())).setMinSize(1)).setRestartAllServices()).build();

    RegexAttributeDefinitions() {
    }

    private static class RegExValidator
    extends StringLengthValidator {
        private RegExValidator() {
            super(1, false, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String pattern = value.asString();
            try {
                Pattern.compile(pattern);
            }
            catch (IllegalArgumentException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidRegularExpression(pattern, e);
            }
        }
    }

    private static class CaptureGroupRexExValidator
    extends RegExValidator {
        private CaptureGroupRexExValidator() {
        }

        @Override
        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String pattern = value.asString();
            int groupCount = Pattern.compile(pattern).matcher("").groupCount();
            if (groupCount < 1) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.patternRequiresCaptureGroup(pattern);
            }
        }
    }
}

