/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.Indexer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.core.stats.impl.SearchStatsRetriever;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.security.actions.SecurityActions;

public final class ComponentRegistryUtils {
    private ComponentRegistryUtils() {
    }

    private static <T> T getRequiredComponent(Cache<?, ?> cache, Class<T> clazz, String name) {
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache());
        Object component = componentRegistry.getComponent(clazz, name == null ? clazz.getName() : name);
        if (component == null) {
            throw new IllegalStateException(clazz.getName() + " not found in component registry");
        }
        return (T)component;
    }

    private static void ensureIndexed(Cache<?, ?> cache) {
        Configuration cfg = SecurityActions.getCacheConfiguration((AdvancedCache)cache.getAdvancedCache());
        if (!cfg.indexing().enabled()) {
            throw new IllegalStateException("Indexing was not enabled on cache " + cache.getName());
        }
    }

    public static SearchMapping getSearchMapping(Cache<?, ?> cache) {
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache());
        return (SearchMapping)componentRegistry.getComponent(SearchMapping.class, SearchMapping.class.getName());
    }

    public static KeyPartitioner getKeyPartitioner(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, KeyPartitioner.class, null);
    }

    public static QueryInterceptor getQueryInterceptor(Cache<?, ?> cache) {
        ComponentRegistryUtils.ensureIndexed(cache);
        return ComponentRegistryUtils.getRequiredComponent(cache, QueryInterceptor.class, null);
    }

    public static LocalQueryStatistics getLocalQueryStatistics(Cache<?, ?> cache) {
        return (LocalQueryStatistics)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(LocalQueryStatistics.class);
    }

    public static SearchStatsRetriever getSearchStatsRetriever(Cache<?, ?> cache) {
        return (SearchStatsRetriever)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(SearchStatsRetriever.class);
    }

    public static KeyTransformationHandler getKeyTransformationHandler(Cache<?, ?> cache) {
        ComponentRegistryUtils.ensureIndexed(cache);
        return ComponentRegistryUtils.getRequiredComponent(cache, KeyTransformationHandler.class, null);
    }

    public static QueryEngine<Class<?>> getEmbeddedQueryEngine(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, QueryEngine.class, null);
    }

    public static TimeService getTimeService(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, TimeService.class, null);
    }

    public static ScheduledExecutorService getTimeoutScheduledExecutor(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, ScheduledExecutorService.class, "org.infinispan.executors.timeout");
    }

    public static QueryCache getQueryCache(Cache<?, ?> cache) {
        return (QueryCache)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(QueryCache.class);
    }

    public static Indexer getIndexer(AdvancedCache<?, ?> cache) {
        ComponentRegistryUtils.ensureIndexed(cache);
        return ComponentRegistryUtils.getRequiredComponent(cache, Indexer.class, null);
    }

    public static InfinispanQueryStatisticsInfo getQueryStatistics(AdvancedCache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, InfinispanQueryStatisticsInfo.class, null);
    }
}

