/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan;

import jakarta.transaction.TransactionManager;
import java.time.Duration;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.BasicCache;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.BasicCacheContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.batch.SimpleContextualBatchFactory;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatchFactory;
import org.wildfly.clustering.function.Supplier;

public interface BasicCacheConfiguration
extends CacheConfiguration,
BasicCacheContainerConfiguration {
    @Override
    default public String getName() {
        return this.getCache().getName();
    }

    public <K, V> BasicCache<K, V> getCache();

    public <K, V> CacheEntryMutatorFactory<K, V> getCacheEntryMutatorFactory();

    public <K, V, O> CacheEntryMutatorFactory<K, O> getCacheEntryMutatorFactory(Function<O, BiFunction<Object, V, V>> var1);

    public Optional<TransactionManager> getTransactionManager();

    public Duration getStopTimeout();

    default public Supplier<Batch> getBatchFactory() {
        return this.getTransactionManager().map(tm -> new TransactionalBatchFactory(this.getName(), (TransactionManager)tm, CacheException::new)).orElseGet(() -> new SimpleContextualBatchFactory(this.getName()));
    }
}

