/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import io.smallrye.config.source.file.FileSystemConfigSource;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.Registry;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;

class ConfigSourceRootRegistrationService
implements Service {
    private final String name;
    private final String path;
    private final String relativeTo;
    private final int ordinal;
    private final Supplier<PathManager> pathManager;
    private final Registry<ConfigSourceProvider> providerRegistry;

    private ConfigSourceRootRegistrationService(String name, String path, String relativeTo, int ordinal, Supplier<PathManager> pathManager, Registry<ConfigSourceProvider> sources) {
        this.name = name;
        this.path = path;
        this.relativeTo = relativeTo;
        this.ordinal = ordinal;
        this.pathManager = pathManager;
        this.providerRegistry = sources;
    }

    static void install(OperationContext context, String name, String path, String relativeTo, int ordinal, Registry<ConfigSourceProvider> registry) {
        ServiceBuilder builder = context.getServiceTarget().addService(ServiceNames.CONFIG_SOURCE_ROOT.append(new String[]{name}));
        Supplier pathManager = builder.requires(context.getCapabilityServiceName(PathManager.SERVICE_DESCRIPTOR));
        builder.setInstance((Service)new ConfigSourceRootRegistrationService(name, path, relativeTo, ordinal, pathManager, registry)).install();
    }

    public void start(StartContext startContext) {
        String relativeToPath = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)this.path) ? null : this.relativeTo;
        String dirPath = this.pathManager.get().resolveRelativePathEntry(this.path, relativeToPath);
        File dir = new File(dirPath);
        MicroProfileConfigLogger.ROOT_LOGGER.loadConfigSourceRootFromDir(dir.getAbsolutePath());
        this.providerRegistry.register(this.name, new RootDirectoryConfigSourceProvider(this.name, dir, this.ordinal));
    }

    public void stop(StopContext context) {
        this.providerRegistry.unregister(this.name);
    }

    private static class RootDirectoryConfigSourceProvider
    implements ConfigSourceProvider {
        private final String name;
        private final File rootDirectory;
        private int ordinal;

        public RootDirectoryConfigSourceProvider(String name, File rootDirectory, int ordinal) {
            this.name = name;
            this.rootDirectory = rootDirectory;
            this.ordinal = ordinal;
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            TreeMap<String, FileSystemConfigSource> map = new TreeMap<String, FileSystemConfigSource>();
            File[] files = this.rootDirectory.listFiles();
            ArrayList<String> configSourceDirs = new ArrayList<String>();
            if (files != null) {
                for (File file : this.rootDirectory.listFiles()) {
                    if (!file.isDirectory()) continue;
                    map.put(file.getName(), new FileSystemConfigSource(file, this.ordinal));
                    configSourceDirs.add(file.getAbsolutePath());
                }
            }
            MicroProfileConfigLogger.ROOT_LOGGER.logDirectoriesUnderConfigSourceRoot(this.name, configSourceDirs);
            return map.values();
        }
    }
}

