/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.clustering.server.GroupMember;

public interface ServiceProviderRegistrationEvent<M extends GroupMember> {
    public Set<M> getPreviousProviders();

    public Set<M> getCurrentProviders();

    default public Set<M> getObsoleteProviders() {
        HashSet<M> members = new HashSet<M>(this.getPreviousProviders());
        members.removeAll(this.getCurrentProviders());
        return Collections.unmodifiableSet(members);
    }

    default public Set<M> getNewProviders() {
        HashSet<M> members = new HashSet<M>(this.getCurrentProviders());
        members.removeAll(this.getPreviousProviders());
        return Collections.unmodifiableSet(members);
    }
}

